/*
 * Decompiled with CFR 0.152.
 */
package com.owc.tools.files.remote.tasks;

import com.owc.tools.files.remote.RemoteFileSystemCheck;
import com.owc.tools.files.remote.RemoteFileSystemTaskFailedException;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ProcessStoppedException;
import com.rapidminer.operator.UserError;
import org.apache.commons.vfs2.AllFileSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;

public class CopyRemoteFileOrFolderCheck
extends RemoteFileSystemCheck {
    FileObject source;
    FileObject destination;

    public CopyRemoteFileOrFolderCheck(FileSystemManager manager, String source, String dest) {
        super(manager, "toolkit.copy_file", source, dest);
    }

    @Override
    public void performRemoteCheck(Operator op, long delayMillis, int numberOfRetries, FileObject remoteFile) throws RemoteFileSystemTaskFailedException, UserError, ProcessStoppedException {
        if (this.source == null) {
            throw new RemoteFileSystemTaskFailedException(new UserError(op, "toolkit.remote_file.check.copy.source_not_set"));
        }
        try {
            remoteFile.copyFrom(this.source, new AllFileSelector());
        }
        catch (FileSystemException e) {
            throw new RemoteFileSystemTaskFailedException(new UserError(op, (Throwable)e, "toolkit.remote_files.copy_file_to_location.failed", new Object[]{e.getMessage()}));
        }
    }

    public void setSource(FileObject source) {
        this.source = source;
    }

    public void setDestination(FileObject destination) {
        this.destination = destination;
    }

    public FileObject getSource() {
        return this.source;
    }

    public FileObject getDestination() {
        return this.destination;
    }
}

