/*
 * Decompiled with CFR 0.152.
 */
package com.owc.tools.files.remote.tasks;

import com.owc.tools.files.remote.RemoteFileSystemCheck;
import com.owc.tools.files.remote.RemoteFileSystemOperations;
import com.owc.tools.files.remote.RemoteFileSystemTaskFailedException;
import com.owc.tools.files.remote.tasks.ExistsRemoteFolderAndFileCheck;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import org.apache.commons.vfs2.AllFileSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;

public class DeleteRemoteFolderChildrenCheck
extends RemoteFileSystemCheck {
    public DeleteRemoteFolderChildrenCheck(FileSystemManager manager, String fileName) {
        super(manager, "toolkit.delete_file", fileName);
    }

    @Override
    public void performRemoteCheck(Operator op, long delayMillis, int numberOfRetries, FileObject remoteFile) throws RemoteFileSystemTaskFailedException, OperatorException {
        try {
            RemoteFileSystemOperations.getInstance().performRemoteFileSystemCheck(op, new ExistsRemoteFolderAndFileCheck(this.manager, remoteFile.getName().getBaseName()), delayMillis, numberOfRetries, remoteFile);
            try {
                remoteFile.delete(new AllFileSelector());
            }
            catch (FileSystemException e) {
                throw new RemoteFileSystemTaskFailedException(new UserError(op, (Throwable)e, "toolkit.remote_files.delete_file.remote_file_system_error", new Object[]{e.getMessage()}));
            }
        }
        catch (RemoteFileSystemTaskFailedException e) {
            throw e.getUserError();
        }
    }
}

