/*
 * Decompiled with CFR 0.152.
 */
package com.owc.tools.files.remote.tasks;

import com.owc.tools.files.remote.RemoteFileSystemCheck;
import com.owc.tools.files.remote.RemoteFileSystemOperations;
import com.owc.tools.files.remote.RemoteFileSystemTaskFailedException;
import com.owc.tools.files.remote.tasks.CopyRemoteFileOrFolderCheck;
import com.owc.tools.files.remote.tasks.DeleteRemoteFolderCheck;
import com.owc.tools.files.remote.tasks.DeleteRemoteFolderChildrenCheck;
import com.owc.tools.files.remote.tasks.ExistsRemoteFolderAndFileCheck;
import com.owc.tools.files.remote.tasks.NotExistsRemoteFolderAndFileCheck;
import com.owc.tools.files.remote.tasks.ResolveRemoteFileWithUriTask;
import com.owc.tools.files.remote.tasks.SetDestinationFileOrFolderCheck;
import com.owc.tools.files.remote.tasks.SetSourceFileOrFolderCheck;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;

public class MoveRemoteFileCheck
extends RemoteFileSystemCheck {
    String sourceFileUri;
    String destFileUri;
    boolean overwriteExtiting;
    FileSystemOptions souceOptions;
    FileSystemOptions destOptions;
    FileObject resultingFile;

    public MoveRemoteFileCheck(FileSystemManager manager, String sourceFileUri, String destFileUri, FileSystemOptions srouceOptions, FileSystemOptions destOptions, boolean overwriteExtiting) {
        super(manager, "task.toolkit.move_file", sourceFileUri, destFileUri);
        this.sourceFileUri = sourceFileUri;
        this.destFileUri = destFileUri;
        this.overwriteExtiting = overwriteExtiting;
        this.souceOptions = srouceOptions;
        this.destOptions = destOptions;
    }

    @Override
    public void performRemoteCheck(Operator op, long delayMillis, int numberOfRetries, FileObject remoteFile) throws RemoteFileSystemTaskFailedException, OperatorException {
        String compareNameSource = this.sourceFileUri;
        String compareNameDest = this.destFileUri;
        while (compareNameSource.endsWith("/")) {
            compareNameSource = compareNameSource.substring(0, compareNameSource.length() - 1);
        }
        while (compareNameSource.endsWith("\\")) {
            compareNameSource = compareNameSource.substring(0, compareNameSource.length() - 1);
        }
        while (compareNameDest.endsWith("/")) {
            compareNameDest = compareNameDest.substring(0, compareNameDest.length() - 1);
        }
        while (compareNameDest.endsWith("\\")) {
            compareNameDest = compareNameDest.substring(0, compareNameDest.length() - 1);
        }
        if (compareNameDest.equals(compareNameSource)) {
            ResolveRemoteFileWithUriTask resolveSource = new ResolveRemoteFileWithUriTask(this.manager, this.sourceFileUri, this.souceOptions, new RemoteFileSystemCheck[0]);
            this.resultingFile = RemoteFileSystemOperations.getInstance().performRemoteFileSystemTask(op, resolveSource, delayMillis, numberOfRetries);
            return;
        }
        ExistsRemoteFolderAndFileCheck sourceExistenceCheck = new ExistsRemoteFolderAndFileCheck(this.manager, this.sourceFileUri);
        NotExistsRemoteFolderAndFileCheck destNotExistenceCheck = new NotExistsRemoteFolderAndFileCheck(this.manager, this.destFileUri);
        CopyRemoteFileOrFolderCheck copyFile = new CopyRemoteFileOrFolderCheck(this.manager, this.sourceFileUri, this.destFileUri);
        SetSourceFileOrFolderCheck setSource = new SetSourceFileOrFolderCheck(this.manager, copyFile);
        SetDestinationFileOrFolderCheck setDestination = new SetDestinationFileOrFolderCheck(this.manager, copyFile);
        ResolveRemoteFileWithUriTask resolveDestTask = !this.overwriteExtiting ? new ResolveRemoteFileWithUriTask(this.manager, this.destFileUri, this.destOptions, destNotExistenceCheck, copyFile, setDestination) : new ResolveRemoteFileWithUriTask(this.manager, this.destFileUri, this.destOptions, copyFile, setDestination);
        ResolveRemoteFileWithUriTask[] tasks = new ResolveRemoteFileWithUriTask[]{resolveDestTask};
        ResolveRemoteFileWithUriTask resolveSource = new ResolveRemoteFileWithUriTask(this.manager, this.sourceFileUri, this.souceOptions, tasks, sourceExistenceCheck, setSource);
        try {
            this.resultingFile = RemoteFileSystemOperations.getInstance().performRemoteFileSystemTask(op, resolveSource, delayMillis, numberOfRetries);
        }
        catch (RemoteFileSystemTaskFailedException e) {
            throw e.getUserError();
        }
        DeleteRemoteFolderChildrenCheck delteCheck = new DeleteRemoteFolderChildrenCheck(this.manager, this.sourceFileUri);
        ResolveRemoteFileWithUriTask resolveTask = new ResolveRemoteFileWithUriTask(this.manager, this.sourceFileUri, this.souceOptions, delteCheck);
        try {
            RemoteFileSystemOperations.getInstance().performRemoteFileSystemTask(op, resolveTask, delayMillis, numberOfRetries);
        }
        catch (RemoteFileSystemTaskFailedException e) {
            throw e.getUserError();
        }
        DeleteRemoteFolderCheck deleteRoot = new DeleteRemoteFolderCheck(this.manager, this.sourceFileUri);
        ResolveRemoteFileWithUriTask resolveSingleDeleteTask = new ResolveRemoteFileWithUriTask(this.manager, this.sourceFileUri, this.souceOptions, deleteRoot);
        try {
            RemoteFileSystemOperations.getInstance().performRemoteFileSystemTask(op, resolveSingleDeleteTask, delayMillis, numberOfRetries);
        }
        catch (RemoteFileSystemTaskFailedException e) {
            throw e.getUserError();
        }
    }

    public FileObject getResultingFile() {
        return this.resultingFile;
    }
}

