/*
 * Decompiled with CFR 0.152.
 */
package com.owc.tools.files.remote.tasks;

import com.owc.tools.files.remote.RemoteFileSystemCheck;
import com.owc.tools.files.remote.RemoteFileSystemOperations;
import com.owc.tools.files.remote.RemoteFileSystemTask;
import com.owc.tools.files.remote.RemoteFileSystemTaskFailedException;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;

public class ResolveRemoteFileTask
extends RemoteFileSystemTask<FileObject> {
    FileObject remoteFile;
    RemoteFileSystemCheck[] additionalChecks;
    RemoteFileSystemTask<FileObject>[] additionalTasks;

    public ResolveRemoteFileTask(FileSystemManager manager, FileObject remoteFile, RemoteFileSystemCheck ... additionalChecks) {
        super(manager, "toolkit.resolve_file", remoteFile.getName().getBaseName());
        this.remoteFile = remoteFile;
        this.additionalChecks = additionalChecks;
    }

    public ResolveRemoteFileTask(FileSystemManager manager, FileObject remoteFile, RemoteFileSystemTask<FileObject> ... additionalTasks) {
        this(manager, remoteFile, new RemoteFileSystemCheck[0]);
        this.additionalTasks = additionalTasks;
    }

    @Override
    public FileObject performRemoteTask(Operator op, long delayMillis, int numberOfRetries) throws RemoteFileSystemTaskFailedException, UserError, OperatorException {
        if (this.additionalTasks == null) {
            this.additionalTasks = new RemoteFileSystemTask[0];
        } else if (this.additionalChecks == null) {
            this.additionalChecks = new RemoteFileSystemCheck[0];
        }
        for (RemoteFileSystemCheck remoteCheck : this.additionalChecks) {
            if (op != null) {
                op.checkForStop();
            }
            try {
                RemoteFileSystemOperations.getInstance().performRemoteFileSystemCheck(op, remoteCheck, delayMillis, numberOfRetries, this.remoteFile);
            }
            catch (RemoteFileSystemTaskFailedException e) {
                throw e.getUserError();
            }
        }
        FileObject changedFile = null;
        for (RemoteFileSystemTask<FileObject> remoteTask : this.additionalTasks) {
            if (op != null) {
                op.checkForStop();
            }
            try {
                changedFile = RemoteFileSystemOperations.getInstance().performRemoteFileSystemTask(op, remoteTask, delayMillis, numberOfRetries);
            }
            catch (RemoteFileSystemTaskFailedException e) {
                throw e.getUserError();
            }
        }
        this.manager.getFilesCache().clear(this.remoteFile.getFileSystem());
        if (changedFile != null) {
            return changedFile;
        }
        return this.remoteFile;
    }
}

