/*
 * Decompiled with CFR 0.152.
 */
package com.owc.tools.files.remote.tasks;

import com.owc.tools.files.remote.RemoteFileSystemCheck;
import com.owc.tools.files.remote.RemoteFileSystemOperations;
import com.owc.tools.files.remote.RemoteFileSystemTask;
import com.owc.tools.files.remote.RemoteFileSystemTaskFailedException;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;

public class ResolveRemoteFileWithUriTask
extends RemoteFileSystemTask<FileObject> {
    String fileUri;
    RemoteFileSystemCheck[] additionalChecks;
    RemoteFileSystemTask<FileObject>[] additionalTasks;
    FileSystemOptions options;

    public ResolveRemoteFileWithUriTask(FileSystemManager manager, String fileUri, FileSystemOptions options, RemoteFileSystemCheck ... additionalChecks) {
        super(manager, "toolkit.resolve_file", fileUri);
        this.fileUri = fileUri;
        this.additionalChecks = additionalChecks;
        this.options = options != null ? options : new FileSystemOptions();
    }

    public ResolveRemoteFileWithUriTask(FileSystemManager manager, String fileUri, FileSystemOptions options, RemoteFileSystemTask<FileObject>[] additionalTasks, RemoteFileSystemCheck ... additionalChecks) {
        this(manager, fileUri, options, additionalChecks);
        this.additionalTasks = additionalTasks;
    }

    public ResolveRemoteFileWithUriTask(FileSystemManager manager, String fileUri, FileSystemOptions options, RemoteFileSystemTask<FileObject> ... additionalTasks) {
        this(manager, fileUri, options, new RemoteFileSystemCheck[0]);
        this.additionalTasks = additionalTasks;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileObject performRemoteTask(Operator op, long delayMillis, int numberOfRetries) throws RemoteFileSystemTaskFailedException, OperatorException {
        if (this.additionalTasks == null) {
            this.additionalTasks = new RemoteFileSystemTask[0];
        } else if (this.additionalChecks == null) {
            this.additionalChecks = new RemoteFileSystemCheck[0];
        }
        try (FileObject file = this.manager.resolveFile(this.fileUri, this.options);){
            FileObject changedFile = null;
            for (RemoteFileSystemCheck remoteCheck : this.additionalChecks) {
                if (op != null) {
                    op.checkForStop();
                }
                try {
                    RemoteFileSystemOperations.getInstance().performRemoteFileSystemCheck(op, remoteCheck, delayMillis, numberOfRetries, file);
                }
                catch (RemoteFileSystemTaskFailedException e) {
                    throw e.getUserError();
                }
            }
            for (RemoteFileSystemTask<FileObject> remoteTask : this.additionalTasks) {
                if (op != null) {
                    op.checkForStop();
                }
                try {
                    changedFile = RemoteFileSystemOperations.getInstance().performRemoteFileSystemTask(op, remoteTask, delayMillis, numberOfRetries);
                }
                catch (RemoteFileSystemTaskFailedException e) {
                    throw e.getUserError();
                }
            }
            this.manager.getFilesCache().clear(file.getFileSystem());
            if (changedFile != null) {
                FileObject fileObject = changedFile;
                return fileObject;
            }
            FileObject fileObject = file;
            return fileObject;
        }
        catch (FileSystemException e) {
            throw new RemoteFileSystemTaskFailedException(new UserError(op, (Throwable)e, "toolkit.remote_files.resolve_file", new Object[]{this.fileUri, e.getMessage()}));
        }
    }
}

