/*
 * Decompiled with CFR 0.152.
 */
package com.owc.tools.files.remote.tasks;

import com.owc.tools.files.remote.RemoteFileSystemTask;
import com.owc.tools.files.remote.RemoteFileSystemTaskFailedException;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessStoppedException;
import com.rapidminer.operator.UserError;
import java.io.InputStream;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;

public class RetrieveInputStreamTask
extends RemoteFileSystemTask<InputStream> {
    FileObject fileObject;

    public RetrieveInputStreamTask(FileSystemManager manager, FileObject fileObject) {
        super(manager, "toolkit.get_inputstream", fileObject.getPublicURIString());
        this.fileObject = fileObject;
    }

    @Override
    public InputStream performRemoteTask(Operator op, long delayMillis, int numberOfRetries) throws RemoteFileSystemTaskFailedException, UserError, OperatorException, ProcessStoppedException {
        InputStream is;
        try {
            is = this.fileObject.getContent().getInputStream();
            if (is == null) {
                throw new RemoteFileSystemTaskFailedException(new UserError(op, "toolkit.remote_file.remote_file_object.input_stream.fail", new Object[]{this.fileObject.getPublicURIString()}));
            }
        }
        catch (FileSystemException e) {
            throw new RemoteFileSystemTaskFailedException(new UserError(op, (Throwable)e, "toolkit.remote_file.remote_file_object.input_stream.fail", new Object[]{this.fileObject.getPublicURIString()}));
        }
        return is;
    }
}

