/*
 * Decompiled with CFR 0.152.
 */
package com.owc.tools.files.remote.tasks;

import com.owc.tools.files.remote.RemoteFileSystemOperations;
import com.owc.tools.files.remote.RemoteFileSystemTask;
import com.owc.tools.files.remote.RemoteFileSystemTaskFailedException;
import com.owc.tools.files.remote.tasks.CreateTempFileTask;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessStoppedException;
import com.rapidminer.operator.UserError;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;

public class WriteToLocalCheck
extends RemoteFileSystemTask<File> {
    String localName;
    FileObject remoteFile;

    public WriteToLocalCheck(FileSystemManager manager, String localName, FileObject remoteFile) {
        super(manager, "toolkit.write_to_local", new Object[0]);
        this.localName = localName;
        this.remoteFile = remoteFile;
    }

    @Override
    public File performRemoteTask(Operator op, long delayMillis, int numberOfRetries) throws RemoteFileSystemTaskFailedException, UserError, OperatorException, ProcessStoppedException {
        File file;
        CreateTempFileTask createFileTask = new CreateTempFileTask(this.manager, this.localName);
        try {
            file = RemoteFileSystemOperations.getInstance().performRemoteFileSystemTask(op, createFileTask, delayMillis, numberOfRetries);
        }
        catch (RemoteFileSystemTaskFailedException e) {
            throw e.getUserError();
        }
        try (FileOutputStream fos = new FileOutputStream(file);
             FileContent content = this.remoteFile.getContent();){
            try {
                content.write(fos);
            }
            catch (IOException e) {
                UserError error = new UserError(op, (Throwable)e, 303, new Object[]{this.localName, e.getMessage()});
                throw new RemoteFileSystemTaskFailedException(error);
            }
        }
        catch (FileNotFoundException e) {
            throw new RemoteFileSystemTaskFailedException(new UserError(op, (Throwable)e, "toolkit.remote_files.resolve_file", new Object[]{this.remoteFile.getPublicURIString(), e.getMessage()}));
        }
        catch (IOException e) {
            throw new RemoteFileSystemTaskFailedException(new UserError(op, (Throwable)e, "toolkit.remote_file.task.retriev_content"));
        }
        return file;
    }
}

