/*
 * Decompiled with CFR 0.152.
 */
package com.owc.vfs2.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;

public final class AdvancedVFS {
    private static Boolean uriStyle;
    private static FileSystemManager instance;

    private AdvancedVFS() {
    }

    public static synchronized FileSystemManager getManager() throws FileSystemException {
        if (instance == null) {
            instance = AdvancedVFS.createManager("com.owc.vfs2.impl.AdvancedStandardFileSystemManager");
        }
        return instance;
    }

    private static FileSystemManager createManager(String managerClassName) throws FileSystemException {
        try {
            Class<?> mgrClass = Class.forName(managerClassName);
            FileSystemManager mgr = (FileSystemManager)mgrClass.newInstance();
            try {
                Method initMethod = mgrClass.getMethod("init", null);
                initMethod.invoke((Object)mgr, (Object[])null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return mgr;
        }
        catch (InvocationTargetException e) {
            throw new FileSystemException("vfs/create-manager.error", (Object)managerClassName, e.getTargetException());
        }
        catch (Exception e) {
            throw new FileSystemException("vfs/create-manager.error", (Object)managerClassName, (Throwable)e);
        }
    }

    public static boolean isUriStyle() {
        if (uriStyle == null) {
            uriStyle = Boolean.FALSE;
        }
        return uriStyle;
    }

    public static void setUriStyle(boolean uriStyle) {
        if (AdvancedVFS.uriStyle != null && AdvancedVFS.uriStyle != uriStyle) {
            throw new IllegalStateException("AdvancedVFS.uriStyle was already set differently.");
        }
        VFS.setUriStyle(uriStyle);
        AdvancedVFS.uriStyle = uriStyle;
    }
}

