/*
 * Decompiled with CFR 0.152.
 */
package com.owc.vfs2.impl.ftp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.ftp.FTPClientWrapper;
import org.apache.commons.vfs2.provider.ftp.FtpClient;
import org.apache.commons.vfs2.provider.ftp.FtpClientFactory;
import org.apache.commons.vfs2.provider.ftp.FtpFileNameParser;
import org.apache.commons.vfs2.provider.ftp.FtpFileProvider;
import org.apache.commons.vfs2.util.UserAuthenticatorUtils;

public class AdvancedFTPClientWrapper
implements FtpClient {
    private static final Log LOG = LogFactory.getLog(FTPClientWrapper.class);
    protected final FileSystemOptions fileSystemOptions;
    private final GenericFileName root;
    private FTPClient ftpClient;
    private Object lock = new Object();
    private FileName currentWorkingDirectory = null;

    protected AdvancedFTPClientWrapper(GenericFileName root, FileSystemOptions fileSystemOptions) throws FileSystemException {
        this.currentWorkingDirectory = root;
        this.root = root;
        this.fileSystemOptions = fileSystemOptions;
        try {
            this.getFtpClient().changeWorkingDirectory(this.getRoot().getPath());
        }
        catch (IOException e) {
            try {
                this.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new FileSystemException(e);
        }
    }

    public GenericFileName getRoot() {
        return this.root;
    }

    public FileSystemOptions getFileSystemOptions() {
        return this.fileSystemOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FTPClient createClient() throws FileSystemException {
        FTPClient fTPClient;
        GenericFileName rootName = this.getRoot();
        UserAuthenticationData authData = null;
        try {
            authData = UserAuthenticatorUtils.authenticate(this.fileSystemOptions, FtpFileProvider.AUTHENTICATOR_TYPES);
            fTPClient = this.createClient(rootName, authData);
        }
        catch (Throwable throwable) {
            UserAuthenticatorUtils.cleanup(authData);
            throw throwable;
        }
        UserAuthenticatorUtils.cleanup(authData);
        return fTPClient;
    }

    protected FTPClient createClient(GenericFileName rootName, UserAuthenticationData authData) throws FileSystemException {
        return FtpClientFactory.createConnection(rootName.getHostName(), rootName.getPort(), UserAuthenticatorUtils.getData(authData, UserAuthenticationData.USERNAME, UserAuthenticatorUtils.toChar(rootName.getUserName())), UserAuthenticatorUtils.getData(authData, UserAuthenticationData.PASSWORD, UserAuthenticatorUtils.toChar(rootName.getPassword())), rootName.getPath(), this.getFileSystemOptions());
    }

    private synchronized FTPClient getFtpClient() throws FileSystemException {
        if (this.ftpClient == null) {
            this.ftpClient = this.createClient();
            this.currentWorkingDirectory = this.getRoot();
        }
        return this.ftpClient;
    }

    @Override
    public boolean isConnected() throws FileSystemException {
        if (this.ftpClient != null && this.ftpClient.isConnected()) {
            return true;
        }
        this.currentWorkingDirectory = this.getRoot();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void disconnect() throws IOException {
        try {
            this.getFtpClient().quit();
            return;
        }
        catch (IOException e) {
            LOG.debug("I/O exception while trying to quit, probably it's a timed out connection, ignoring.", e);
            return;
        }
        finally {
            try {
                this.getFtpClient().disconnect();
            }
            catch (IOException e) {
                LOG.warn("I/O exception while trying to disconnect, probably it's a closed connection, ignoring.", e);
            }
            finally {
                this.ftpClient = null;
                this.currentWorkingDirectory = this.getRoot();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FTPFile[] listFiles(String relativePath) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            String relPath = this.changeWorkingDirectory(relativePath, false);
            try {
                FTPFile[] files = this.listFilesInDirectory(relPath);
                return files;
            }
            catch (IOException e) {
                this.disconnect();
                FTPFile[] files = this.listFilesInDirectory(relPath);
                return files;
            }
        }
    }

    private FTPFile[] listFilesInDirectory(String relPath) throws IOException {
        FTPFile[] files = this.getFtpClient().listFiles(relPath);
        if (FTPReply.isPositiveCompletion(this.getFtpClient().getReplyCode())) {
            return files;
        }
        String workingDirectory = null;
        if (relPath != null) {
            workingDirectory = this.getFtpClient().printWorkingDirectory();
            if (!this.getFtpClient().changeWorkingDirectory(relPath)) {
                return null;
            }
        }
        files = this.getFtpClient().listFiles();
        if (relPath != null && !this.getFtpClient().changeWorkingDirectory(workingDirectory)) {
            throw new FileSystemException("vfs.provider.ftp.wrapper/change-work-directory-back.error", (Object)workingDirectory);
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeDirectory(String relativePath) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            String relPath = this.changeWorkingDirectory(relativePath, true);
            try {
                return this.getFtpClient().removeDirectory(relPath);
            }
            catch (IOException e) {
                this.disconnect();
                return this.getFtpClient().removeDirectory(relPath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteFile(String relativePath) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            String relPath = this.changeWorkingDirectory(relativePath, true);
            try {
                return this.getFtpClient().deleteFile(relPath);
            }
            catch (IOException e) {
                this.disconnect();
                return this.getFtpClient().deleteFile(relPath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rename(String oldName, String newName) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            String newNameRelativeToWorkingPath;
            String oldNameRelativeToWorkingPath;
            if (oldName.equals(newName)) {
                return true;
            }
            String workingPath = this.greatestCommonPrefix(oldName, newName);
            if (!workingPath.isEmpty()) {
                oldNameRelativeToWorkingPath = oldName.substring(workingPath.length(), oldName.length());
                newNameRelativeToWorkingPath = newName.substring(workingPath.length(), newName.length());
            } else {
                oldNameRelativeToWorkingPath = oldName;
                newNameRelativeToWorkingPath = newName;
            }
            try {
                this.getFtpClient().changeWorkingDirectory(workingPath);
                return this.getFtpClient().rename(oldNameRelativeToWorkingPath, newNameRelativeToWorkingPath);
            }
            catch (IOException e) {
                this.disconnect();
                return this.getFtpClient().rename(oldName, newName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean makeDirectory(String relativePath) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            String relPath = this.changeWorkingDirectory(relativePath, true);
            try {
                return this.getFtpClient().makeDirectory(relPath);
            }
            catch (IOException e) {
                this.disconnect();
                return this.getFtpClient().makeDirectory(relPath);
            }
        }
    }

    @Override
    public boolean completePendingCommand() throws IOException {
        if (this.ftpClient != null) {
            return this.getFtpClient().completePendingCommand();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream retrieveFileStream(String relativePath) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            String relPath = this.changeWorkingDirectory(relativePath, true);
            try {
                return this.getFtpClient().retrieveFileStream(relPath);
            }
            catch (IOException e) {
                this.disconnect();
                return this.getFtpClient().retrieveFileStream(relPath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream retrieveFileStream(String relativePath, long restartOffset) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            String relPath = this.changeWorkingDirectory(relativePath, true);
            try {
                FTPClient client = this.getFtpClient();
                client.setRestartOffset(restartOffset);
                return client.retrieveFileStream(relPath);
            }
            catch (IOException e) {
                this.disconnect();
                FTPClient client = this.getFtpClient();
                client.setRestartOffset(restartOffset);
                return client.retrieveFileStream(relPath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream appendFileStream(String relativePath) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            String relPath = this.changeWorkingDirectory(relativePath, true);
            try {
                return this.getFtpClient().appendFileStream(relPath);
            }
            catch (IOException e) {
                this.disconnect();
                return this.getFtpClient().appendFileStream(relPath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream storeFileStream(String relativePath) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            String relPath = this.changeWorkingDirectory(relativePath, true);
            try {
                return this.getFtpClient().storeFileStream(relPath);
            }
            catch (IOException e) {
                this.disconnect();
                return this.getFtpClient().storeFileStream(relPath);
            }
        }
    }

    @Override
    public boolean abort() throws IOException {
        try {
            this.disconnect();
            return true;
        }
        catch (IOException e) {
            this.disconnect();
            return true;
        }
    }

    @Override
    public String getReplyString() throws IOException {
        return this.getFtpClient().getReplyString();
    }

    private String changeWorkingDirectory(String relPath, boolean isFile) throws FileSystemException, IOException {
        if (relPath == null) {
            try {
                this.getFtpClient().changeWorkingDirectory(this.getRoot().getPath());
                this.currentWorkingDirectory = this.getRoot();
                return "";
            }
            catch (IOException e) {
                this.disconnect();
                throw e;
            }
        }
        String rootUri = this.getRoot().getRootURI();
        if (!rootUri.endsWith("/")) {
            rootUri = rootUri + "/";
        }
        FileName fileName = FtpFileNameParser.getInstance().parseUri(null, this.getRoot(), rootUri + relPath);
        FileName targetedFileName = FtpFileNameParser.getInstance().parseUri(null, this.getRoot(), rootUri + relPath);
        if (isFile && (fileName = fileName.getParent()) == null) {
            fileName = this.getRoot();
        }
        try {
            this.getFtpClient().changeWorkingDirectory(fileName.getPath());
            this.currentWorkingDirectory = fileName;
            return this.currentWorkingDirectory.getRelativeName(targetedFileName);
        }
        catch (IOException e) {
            this.disconnect();
            throw e;
        }
    }

    private String greatestCommonPrefix(String oldName, String newName) {
        int minLength = Math.min(oldName.length(), newName.length());
        for (int i = 0; i < minLength; ++i) {
            if (oldName.charAt(i) == newName.charAt(i)) continue;
            return oldName.substring(0, i);
        }
        return oldName.substring(0, minLength);
    }
}

