/*
 * Decompiled with CFR 0.152.
 */
package com.owc.vfs2.impl.ftp;

import com.owc.vfs2.impl.ftp.AdvancedFTPClientWrapper;
import com.owc.vfs2.impl.ftp.AdvancedFtpFileObject;
import com.owc.vfs2.impl.ftp.AdvancedFtpFileProvider;
import com.rapidminer.tools.ParameterService;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.VfsLog;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.ftp.FtpClient;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystem;

public class AdvancedFtpFileSystem
extends AbstractFileSystem {
    private final ConcurrentLinkedQueue<FtpClient> idleClients = new ConcurrentLinkedQueue();

    public AdvancedFtpFileSystem(GenericFileName rootName, FtpClient ftpClient, FileSystemOptions fileSystemOptions) {
        super(rootName, null, fileSystemOptions);
        this.idleClients.add(ftpClient);
    }

    @Override
    protected void doCloseCommunicationLink() {
        while (!this.idleClients.isEmpty()) {
            FtpClient idle = this.idleClients.poll();
            if (idle == null) continue;
            this.closeConnection(idle);
        }
    }

    @Override
    protected void addCapabilities(Collection<Capability> caps) {
        caps.addAll(AdvancedFtpFileProvider.capabilities);
    }

    private void closeConnection(FtpClient client) {
        try {
            if (client.isConnected()) {
                client.disconnect();
            }
        }
        catch (IOException e) {
            VfsLog.warn(this.getLogger(), LogFactory.getLog(FtpFileSystem.class), "vfs.provider.ftp/close-connection.error", e);
        }
    }

    public synchronized FtpClient getClient() throws FileSystemException {
        FtpClient client = this.idleClients.poll();
        if (client != null && !client.isConnected()) {
            try {
                client.disconnect();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            client = null;
        }
        if (client == null) {
            client = this.createAdvancedWrapper();
        }
        return client;
    }

    protected FtpClient createAdvancedWrapper() throws FileSystemException {
        return new AdvancedFTPClientWrapper((GenericFileName)this.getRootName(), this.getFileSystemOptions());
    }

    public void putClient(FtpClient client) {
        String maxNumberParameter = ParameterService.getParameterValue((String)"rmx_toolkit.remote_file_connection_poolsize");
        int maxNumber = 0;
        try {
            maxNumber = Integer.valueOf(maxNumberParameter);
        }
        catch (NumberFormatException e) {
            maxNumber = 0;
        }
        if (this.idleClients.size() >= maxNumber && maxNumber > 0) {
            this.closeConnection(client);
        } else {
            this.idleClients.add(client);
        }
    }

    @Override
    protected FileObject createFile(AbstractFileName name) throws FileSystemException {
        return new AdvancedFtpFileObject(name, this, this.getRootName());
    }

    @Override
    public boolean hasCapability(Capability capability) {
        return super.hasCapability(capability);
    }
}

