/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension;

import com.owc.license.LicenseManager;
import com.owc.license.ProductInformation;
import com.owc.license.VersionHistory;
import com.owc.tools.PluginInitializer;
import com.rapidminer.extension.CacheInitializer;
import com.rapidminer.extension.ConfigurableInitializer;
import com.rapidminer.extension.ExpressionInitializer;
import com.rapidminer.extension.GuiInitializer;
import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.tools.SplashScreen;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.tools.ParameterService;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Properties;

public class PluginInitJackhammerExtension {
    public static final String PRODUCT_NAME = "rmx_toolkit";
    public static final ProductInformation PRODUCT_INFORMATION = new ProductInformation("rmx_toolkit", PluginInitJackhammerExtension.class.getResourceAsStream("/com/owc/license/owc.publicKey"));
    public static final PluginInitializer[] INITIALIZER = new PluginInitializer[]{new ExpressionInitializer(), new CacheInitializer(), new ConfigurableInitializer(), new GuiInitializer()};

    public static void initPlugin() {
        LicenseManager.registerParameters(PRODUCT_NAME);
        try {
            VersionNumber currentVersion = new VersionNumber(1, 3, 22);
            LicenseManager.manageProduct(PRODUCT_INFORMATION, currentVersion, new VersionHistory(){
                {
                    this.put(new VersionNumber(0, 0, 6), "2016-04-01");
                    this.put(new VersionNumber(1, 0, 0), "2016-06-10");
                    this.put(new VersionNumber(1, 3, 0), "2017-03-03");
                    this.put(new VersionNumber(1, 3, 20), "2017-06-08");
                    this.put(new VersionNumber(1, 3, 20), "2017-06-08");
                    this.put(new VersionNumber(2, 1, 774), "2018-02-08");
                }
            });
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        for (PluginInitializer initializer : INITIALIZER) {
            initializer.initPlugin();
        }
    }

    public static void initGui(MainFrame mainframe) {
        for (PluginInitializer initializer : INITIALIZER) {
            initializer.initGui(mainframe);
        }
    }

    public static void initFinalChecks() {
        for (PluginInitializer initializer : INITIALIZER) {
            initializer.initFinalChecks();
        }
    }

    public static void initPluginManager() {
        for (PluginInitializer initializer : INITIALIZER) {
            initializer.initPluginManager();
        }
    }

    public static void initSplashTexts(SplashScreen splashScreen) {
        for (PluginInitializer initializer : INITIALIZER) {
            initializer.initSplashTexts(splashScreen);
        }
    }

    public static void initAboutTexts(Properties aboutBoxProperties) {
        for (PluginInitializer initializer : INITIALIZER) {
            initializer.initAboutTexts(aboutBoxProperties);
        }
    }

    public static Boolean showAboutBox() {
        return true;
    }

    public static InputStream getOperatorStream(ClassLoader loader) {
        return null;
    }

    public static String getParameterValue(String parameterName) {
        String parameterValue = ParameterService.getParameterValue((String)parameterName);
        if (parameterValue == null) {
            parameterValue = ParameterService.getParameterValue((String)("rapidminer." + parameterName));
        }
        return parameterValue;
    }
}

