/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.LinkedHashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mapdb.DataIO;
import org.mapdb.Engine;
import org.mapdb.Fun;
import org.mapdb.LongConcurrentHashMap;
import org.mapdb.Serializer;
import org.mapdb.Store;
import org.mapdb.TxRollbackException;

public class TxEngine
implements Engine {
    protected static final Object TOMBSTONE = new Object();
    protected final ReentrantReadWriteLock commitLock = new ReentrantReadWriteLock(false);
    protected final ReentrantReadWriteLock[] locks;
    protected final int lockScale;
    protected final int lockMask;
    protected volatile boolean uncommitedData = false;
    protected Set<Reference<Tx>> txs = new LinkedHashSet<Reference<Tx>>();
    protected ReferenceQueue<Tx> txQueue = new ReferenceQueue();
    protected final boolean fullTx;
    protected final Queue<Long> preallocRecids;
    protected final int PREALLOC_RECID_SIZE = 128;
    protected final Engine engine;

    protected TxEngine(Engine engine, boolean fullTx, int lockScale) {
        this.engine = engine;
        this.fullTx = fullTx;
        this.preallocRecids = fullTx ? new ArrayBlockingQueue(128) : null;
        this.lockScale = lockScale;
        this.lockMask = lockScale - 1;
        this.locks = new ReentrantReadWriteLock[lockScale];
        for (int i = 0; i < this.locks.length; ++i) {
            this.locks[i] = new ReentrantReadWriteLock(false);
        }
    }

    protected Long preallocRecidTake() {
        if (!this.commitLock.isWriteLockedByCurrentThread()) {
            throw new AssertionError();
        }
        Long recid = this.preallocRecids.poll();
        if (recid != null) {
            return recid;
        }
        if (this.uncommitedData) {
            throw new IllegalAccessError("uncommited data");
        }
        for (int i = 0; i < 128; ++i) {
            this.preallocRecids.add(this.engine.preallocate());
        }
        recid = this.engine.preallocate();
        this.engine.commit();
        this.uncommitedData = false;
        return recid;
    }

    public static Engine createSnapshotFor(Engine engine) {
        if (engine.isReadOnly()) {
            return engine;
        }
        if (engine instanceof TxEngine) {
            return ((TxEngine)engine).snapshot();
        }
        if (engine.canSnapshot()) {
            return engine.snapshot();
        }
        if (engine.getWrappedEngine() != null) {
            return TxEngine.createSnapshotFor(engine.getWrappedEngine());
        }
        throw new UnsupportedOperationException("Snapshots are not enabled, use DBMaker.snapshotEnable()");
    }

    @Override
    public boolean canSnapshot() {
        return true;
    }

    @Override
    public Engine snapshot() {
        this.commitLock.writeLock().lock();
        try {
            this.cleanTxQueue();
            if (this.uncommitedData && this.canRollback()) {
                throw new IllegalAccessError("Can not create snapshot with uncommited data");
            }
            Tx tx = new Tx();
            return tx;
        }
        finally {
            this.commitLock.writeLock().unlock();
        }
    }

    @Override
    public Engine getWrappedEngine() {
        return this.engine;
    }

    @Override
    public void clearCache() {
    }

    @Override
    public void compact() {
    }

    protected void cleanTxQueue() {
        if (!this.commitLock.writeLock().isHeldByCurrentThread()) {
            throw new AssertionError();
        }
        Reference<Tx> ref = this.txQueue.poll();
        while (ref != null) {
            this.txs.remove(ref);
            ref = this.txQueue.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long preallocate() {
        this.commitLock.writeLock().lock();
        try {
            this.uncommitedData = true;
            long recid = this.engine.preallocate();
            ReentrantReadWriteLock.WriteLock lock = this.locks[this.lockPos(recid)].writeLock();
            lock.lock();
            try {
                for (Reference<Tx> txr : this.txs) {
                    Tx tx = txr.get();
                    if (tx == null) continue;
                    tx.old.putIfAbsent(recid, TOMBSTONE);
                }
            }
            finally {
                lock.unlock();
            }
            long l = recid;
            return l;
        }
        finally {
            this.commitLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> long put(A value, Serializer<A> serializer) {
        this.commitLock.readLock().lock();
        try {
            this.uncommitedData = true;
            long recid = this.engine.put(value, serializer);
            ReentrantReadWriteLock.WriteLock lock = this.locks[this.lockPos(recid)].writeLock();
            lock.lock();
            try {
                for (Reference<Tx> txr : this.txs) {
                    Tx tx = txr.get();
                    if (tx == null) continue;
                    tx.old.putIfAbsent(recid, TOMBSTONE);
                }
            }
            finally {
                lock.unlock();
            }
            long l = recid;
            return l;
        }
        finally {
            this.commitLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> A get(long recid, Serializer<A> serializer) {
        this.commitLock.readLock().lock();
        try {
            A a = this.engine.get(recid, serializer);
            return a;
        }
        finally {
            this.commitLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void update(long recid, A value, Serializer<A> serializer) {
        this.commitLock.readLock().lock();
        try {
            this.uncommitedData = true;
            ReentrantReadWriteLock.WriteLock lock = this.locks[this.lockPos(recid)].writeLock();
            lock.lock();
            try {
                A old = this.get(recid, serializer);
                for (Reference<Tx> txr : this.txs) {
                    Tx tx = txr.get();
                    if (tx == null) continue;
                    tx.old.putIfAbsent(recid, old);
                }
                this.engine.update(recid, value, serializer);
            }
            finally {
                lock.unlock();
            }
        }
        finally {
            this.commitLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
        this.commitLock.readLock().lock();
        try {
            this.uncommitedData = true;
            ReentrantReadWriteLock.WriteLock lock = this.locks[this.lockPos(recid)].writeLock();
            lock.lock();
            try {
                boolean ret = this.engine.compareAndSwap(recid, expectedOldValue, newValue, serializer);
                if (ret) {
                    for (Reference<Tx> txr : this.txs) {
                        Tx tx = txr.get();
                        if (tx == null) continue;
                        tx.old.putIfAbsent(recid, expectedOldValue);
                    }
                }
                boolean bl = ret;
                lock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                lock.unlock();
                throw throwable;
            }
        }
        finally {
            this.commitLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void delete(long recid, Serializer<A> serializer) {
        this.commitLock.readLock().lock();
        try {
            this.uncommitedData = true;
            ReentrantReadWriteLock.WriteLock lock = this.locks[this.lockPos(recid)].writeLock();
            lock.lock();
            try {
                A old = this.get(recid, serializer);
                for (Reference<Tx> txr : this.txs) {
                    Tx tx = txr.get();
                    if (tx == null) continue;
                    tx.old.putIfAbsent(recid, old);
                }
                this.engine.delete(recid, serializer);
            }
            finally {
                lock.unlock();
            }
        }
        finally {
            this.commitLock.readLock().unlock();
        }
    }

    @Override
    public void close() {
        this.commitLock.writeLock().lock();
        try {
            this.engine.close();
        }
        finally {
            this.commitLock.writeLock().unlock();
        }
    }

    @Override
    public boolean isClosed() {
        return this.engine.isClosed();
    }

    @Override
    public void commit() {
        this.commitLock.writeLock().lock();
        try {
            this.cleanTxQueue();
            this.engine.commit();
            this.uncommitedData = false;
        }
        finally {
            this.commitLock.writeLock().unlock();
        }
    }

    @Override
    public void rollback() {
        this.commitLock.writeLock().lock();
        try {
            this.cleanTxQueue();
            this.engine.rollback();
            this.uncommitedData = false;
        }
        finally {
            this.commitLock.writeLock().unlock();
        }
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean canRollback() {
        return false;
    }

    protected void superCommit() {
        if (!this.commitLock.isWriteLockedByCurrentThread()) {
            throw new AssertionError();
        }
        this.engine.commit();
    }

    protected <A> void superUpdate(long recid, A value, Serializer<A> serializer) {
        if (!this.commitLock.isWriteLockedByCurrentThread()) {
            throw new AssertionError();
        }
        this.engine.update(recid, value, serializer);
    }

    protected <A> void superDelete(long recid, Serializer<A> serializer) {
        if (!this.commitLock.isWriteLockedByCurrentThread()) {
            throw new AssertionError();
        }
        this.engine.delete(recid, serializer);
    }

    protected <A> A superGet(long recid, Serializer<A> serializer) {
        if (!this.commitLock.isWriteLockedByCurrentThread()) {
            throw new AssertionError();
        }
        return this.engine.get(recid, serializer);
    }

    protected final int lockPos(long recid) {
        return DataIO.longHash(recid) & this.lockMask;
    }

    public class Tx
    implements Engine {
        protected LongConcurrentHashMap old = new LongConcurrentHashMap();
        protected LongConcurrentHashMap<Fun.Pair> mod;
        protected final Reference<Tx> ref;
        protected boolean closed;
        private Store parentEngine;

        public Tx() {
            this.mod = TxEngine.this.fullTx ? new LongConcurrentHashMap() : null;
            this.ref = new WeakReference<Tx>(this, TxEngine.this.txQueue);
            this.closed = false;
            if (!TxEngine.this.commitLock.isWriteLockedByCurrentThread()) {
                throw new AssertionError();
            }
            TxEngine.this.txs.add(this.ref);
        }

        @Override
        public long preallocate() {
            if (!TxEngine.this.fullTx) {
                throw new UnsupportedOperationException("read-only");
            }
            TxEngine.this.commitLock.writeLock().lock();
            try {
                long l = TxEngine.this.preallocRecidTake();
                return l;
            }
            finally {
                TxEngine.this.commitLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <A> long put(A value, Serializer<A> serializer) {
            if (!TxEngine.this.fullTx) {
                throw new UnsupportedOperationException("read-only");
            }
            TxEngine.this.commitLock.writeLock().lock();
            try {
                Long recid = TxEngine.this.preallocRecidTake();
                this.mod.put(recid, new Fun.Pair<A, Serializer<A>>(value, serializer));
                long l = recid;
                return l;
            }
            finally {
                TxEngine.this.commitLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <A> A get(long recid, Serializer<A> serializer) {
            TxEngine.this.commitLock.readLock().lock();
            try {
                A a;
                if (this.closed) {
                    throw new IllegalAccessError("closed");
                }
                ReentrantReadWriteLock.ReadLock lock = TxEngine.this.locks[TxEngine.this.lockPos(recid)].readLock();
                lock.lock();
                try {
                    a = this.getNoLock(recid, serializer);
                    lock.unlock();
                }
                catch (Throwable throwable) {
                    lock.unlock();
                    throw throwable;
                }
                return a;
            }
            finally {
                TxEngine.this.commitLock.readLock().unlock();
            }
        }

        private <A> A getNoLock(long recid, Serializer<A> serializer) {
            Fun.Pair tu;
            if (TxEngine.this.fullTx && (tu = this.mod.get(recid)) != null) {
                if (tu.a == TOMBSTONE) {
                    return null;
                }
                return tu.a;
            }
            Object oldVal = this.old.get(recid);
            if (oldVal != null) {
                if (oldVal == TOMBSTONE) {
                    return null;
                }
                return (A)oldVal;
            }
            return TxEngine.this.get(recid, serializer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <A> void update(long recid, A value, Serializer<A> serializer) {
            if (!TxEngine.this.fullTx) {
                throw new UnsupportedOperationException("read-only");
            }
            TxEngine.this.commitLock.readLock().lock();
            try {
                this.mod.put(recid, new Fun.Pair<A, Serializer<A>>(value, serializer));
            }
            finally {
                TxEngine.this.commitLock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
            if (!TxEngine.this.fullTx) {
                throw new UnsupportedOperationException("read-only");
            }
            TxEngine.this.commitLock.readLock().lock();
            try {
                ReentrantReadWriteLock.WriteLock lock = TxEngine.this.locks[TxEngine.this.lockPos(recid)].writeLock();
                lock.lock();
                try {
                    boolean ret;
                    A oldVal = this.getNoLock(recid, serializer);
                    boolean bl = ret = oldVal == expectedOldValue || oldVal != null && serializer.equals(oldVal, expectedOldValue);
                    if (ret) {
                        this.mod.put(recid, new Fun.Pair<A, Serializer<A>>(newValue, serializer));
                    }
                    boolean bl2 = ret;
                    lock.unlock();
                    return bl2;
                }
                catch (Throwable throwable) {
                    lock.unlock();
                    throw throwable;
                }
            }
            finally {
                TxEngine.this.commitLock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <A> void delete(long recid, Serializer<A> serializer) {
            if (!TxEngine.this.fullTx) {
                throw new UnsupportedOperationException("read-only");
            }
            TxEngine.this.commitLock.readLock().lock();
            try {
                this.mod.put(recid, new Fun.Pair<Object, Serializer<A>>(TOMBSTONE, serializer));
            }
            finally {
                TxEngine.this.commitLock.readLock().unlock();
            }
        }

        @Override
        public void close() {
            this.closed = true;
            this.old.clear();
            this.ref.clear();
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void commit() {
            if (!TxEngine.this.fullTx) {
                throw new UnsupportedOperationException("read-only");
            }
            TxEngine.this.commitLock.writeLock().lock();
            try {
                long recid;
                if (this.closed) {
                    return;
                }
                if (TxEngine.this.uncommitedData) {
                    throw new IllegalAccessError("uncommitted data");
                }
                TxEngine.this.txs.remove(this.ref);
                TxEngine.this.cleanTxQueue();
                LongConcurrentHashMap.LongMapIterator oldIter = this.old.longMapIterator();
                while (oldIter.moveToNext()) {
                    long recid2 = oldIter.key();
                    for (Reference<Tx> ref2 : TxEngine.this.txs) {
                        Tx tx = ref2.get();
                        if (tx == this || tx == null || !tx.mod.containsKey(recid2)) continue;
                        this.close();
                        throw new TxRollbackException();
                    }
                }
                LongConcurrentHashMap.LongMapIterator<Fun.Pair> iter = this.mod.longMapIterator();
                while (iter.moveToNext()) {
                    recid = iter.key();
                    if (!this.old.containsKey(recid)) continue;
                    this.close();
                    throw new TxRollbackException();
                }
                iter = this.mod.longMapIterator();
                while (iter.moveToNext()) {
                    recid = iter.key();
                    Fun.Pair val = iter.value();
                    Serializer ser = (Serializer)val.b;
                    Object old = TxEngine.this.superGet(recid, ser);
                    if (old == null) {
                        old = TOMBSTONE;
                    }
                    for (Reference<Tx> txr : TxEngine.this.txs) {
                        Tx tx = txr.get();
                        if (tx == null || tx == this) continue;
                        tx.old.putIfAbsent(recid, old);
                    }
                    if (val.a == TOMBSTONE) {
                        TxEngine.this.superDelete(recid, ser);
                        continue;
                    }
                    TxEngine.this.superUpdate(recid, val.a, ser);
                }
                TxEngine.this.superCommit();
                this.close();
            }
            finally {
                TxEngine.this.commitLock.writeLock().unlock();
            }
        }

        @Override
        public void rollback() throws UnsupportedOperationException {
            if (!TxEngine.this.fullTx) {
                throw new UnsupportedOperationException("read-only");
            }
            TxEngine.this.commitLock.writeLock().lock();
            try {
                if (this.closed) {
                    return;
                }
                if (TxEngine.this.uncommitedData) {
                    throw new IllegalAccessError("uncommitted data");
                }
                TxEngine.this.txs.remove(this.ref);
                TxEngine.this.cleanTxQueue();
                this.close();
            }
            finally {
                TxEngine.this.commitLock.writeLock().unlock();
            }
        }

        @Override
        public boolean isReadOnly() {
            return !TxEngine.this.fullTx;
        }

        @Override
        public boolean canRollback() {
            return TxEngine.this.fullTx;
        }

        @Override
        public boolean canSnapshot() {
            return false;
        }

        @Override
        public Engine snapshot() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Engine getWrappedEngine() {
            return TxEngine.this.engine;
        }

        @Override
        public void clearCache() {
        }

        @Override
        public void compact() {
        }
    }
}

