/*
 * Decompiled with CFR 0.152.
 */
package com.owc.cryptography;

import com.owc.cryptography.CryptographyService;
import com.owc.tools.Base64Tools;
import com.owc.tools.RandomTools;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class PersistentKeyRing
implements Serializable {
    private static final byte[] SALT = "OldSecureWorld!".getBytes(Charset.forName("utf-8"));
    private static final long serialVersionUID = -5760022663045908877L;
    PublicKey publicKey;
    PrivateKey privateKey;
    PublicKey publicSignatureKey;
    PrivateKey privateSignatureKey;
    String hashingSalt;

    public PersistentKeyRing(String publicEncryptionKey, String privateEncryptionKey, String publicSignatureKey, String privateSignatureKey, String hashingSalt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        this(CryptographyService.derivePublicKey(publicEncryptionKey), CryptographyService.derivePrivateKey(privateEncryptionKey), CryptographyService.derivePublicKey(publicSignatureKey), CryptographyService.derivePrivateKey(privateSignatureKey), hashingSalt);
    }

    public PersistentKeyRing(PublicKey publicEncryptionKey, PrivateKey privateEncryptionKey, PublicKey publicSignatureKey, PrivateKey privateSignatureKey, String hashingSalt) {
        this.publicKey = publicEncryptionKey;
        this.privateKey = privateEncryptionKey;
        this.publicSignatureKey = publicSignatureKey;
        this.privateSignatureKey = privateSignatureKey;
        this.hashingSalt = hashingSalt;
    }

    public String getHashingSaltAsString() {
        return this.hashingSalt;
    }

    public PrivateKey getPrivateSignatureKey() {
        return this.privateSignatureKey;
    }

    public String getPublicKeyAsString() {
        return Base64Tools.encode(this.publicKey.getEncoded());
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public PublicKey getPublicSignatureKey() {
        return this.publicSignatureKey;
    }

    public String getPublicSignatureKeyAsString() {
        return Base64Tools.encode(this.publicSignatureKey.getEncoded());
    }

    public static PersistentKeyRing load(InputStream in, char[] password) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IOException, ClassNotFoundException, InvalidAlgorithmParameterException, InvalidKeySpecException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        PBEKeySpec spec = new PBEKeySpec(password, SALT, 65536, 256);
        SecretKeySpec secret = new SecretKeySpec(factory.generateSecret(spec).getEncoded(), "AES");
        in.read();
        int length = in.read();
        if (length > 0) {
            byte[] iv = new byte[length];
            for (int i = 0; i < length; ++i) {
                int readByte = in.read();
                if (readByte <= 0) {
                    throw new IOException("Illegal key file.");
                }
                iv[i] = (byte)readByte;
            }
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv);
            cipher.init(2, (Key)secret, parameterSpec);
            try (ObjectInputStream ois = new ObjectInputStream(new CipherInputStream(in, cipher));){
                PersistentKeyRing persistentKeyRing = (PersistentKeyRing)ois.readObject();
                return persistentKeyRing;
            }
        }
        throw new IOException("Illegal key file.");
    }

    public static void store(PersistentKeyRing pair, OutputStream out, char[] password) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidKeySpecException, InvalidParameterSpecException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        PBEKeySpec spec = new PBEKeySpec(password, SALT, 65536, 256);
        SecretKeySpec secret = new SecretKeySpec(factory.generateSecret(spec).getEncoded(), "AES");
        byte[] iv = new byte[12];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(iv);
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv);
        cipher.init(1, (Key)secret, parameterSpec);
        out.write(1);
        out.write((byte)iv.length);
        out.write(iv);
        try (ObjectOutputStream ois = new ObjectOutputStream(new CipherOutputStream(out, cipher));){
            ois.writeObject(pair);
        }
    }

    public static PersistentKeyRing generate() throws NoSuchAlgorithmException {
        KeyPair keyPair = CryptographyService.generateAsymmetricKeyPair();
        KeyPair signatureKeyPair = CryptographyService.generateSignatureKeyPair();
        return new PersistentKeyRing(keyPair.getPublic(), keyPair.getPrivate(), signatureKeyPair.getPublic(), signatureKeyPair.getPrivate(), RandomTools.generateRandomString(50));
    }

    static byte[] toBytes(char[] chars) {
        CharBuffer charBuffer = CharBuffer.wrap(chars);
        ByteBuffer byteBuffer = Charset.forName("UTF-8").encode(charBuffer);
        byte[] bytes = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
        Arrays.fill(byteBuffer.array(), (byte)0);
        return bytes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.privateKey == null ? 0 : this.privateKey.hashCode());
        result = 31 * result + (this.publicKey == null ? 0 : this.publicKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PersistentKeyRing other = (PersistentKeyRing)obj;
        if (this.privateKey == null ? other.privateKey != null : !this.privateKey.equals(other.privateKey)) {
            return false;
        }
        return !(this.publicKey == null ? other.publicKey != null : !this.publicKey.equals(other.publicKey));
    }
}

