/*
 * Decompiled with CFR 0.152.
 */
package com.owc.io.http;

import com.owc.io.http.AbstractHTTPConnectionConfigurable;
import com.owc.io.http.GzipRequestInterceptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.CacheControl;
import okhttp3.CookieJar;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class HttpConnectionManager {
    public static int METHOD_DELETE = 0;
    public static int METHOD_GET = 1;
    public static int METHOD_HEAD = 2;
    public static int METHOD_MOVE = 3;
    public static int METHOD_PATCH = 4;
    public static int METHOD_POST = 5;
    public static int METHOD_PROPPATCH = 6;
    public static int METHOD_PUT = 7;
    public static int METHOD_REPORT = 8;
    public static String[] METHODS = new String[]{"DELETE", "GET", "HEAD", "MOVE", "PATCH", "POST", "PROPPATCH", "PUT", "REPORT"};
    private static OkHttpClient client;
    private static OkHttpClient compressingClient;
    private static ConcurrentHashMap<String, Long> lastAccessMap;

    public static void init() {
        client = new OkHttpClient.Builder().connectTimeout(1000L, TimeUnit.MILLISECONDS).readTimeout(0L, TimeUnit.MILLISECONDS).writeTimeout(0L, TimeUnit.MILLISECONDS).build();
        compressingClient = new OkHttpClient.Builder().connectTimeout(1000L, TimeUnit.MILLISECONDS).readTimeout(0L, TimeUnit.MILLISECONDS).writeTimeout(0L, TimeUnit.MILLISECONDS).addInterceptor(new GzipRequestInterceptor()).build();
        client.dispatcher().setMaxRequests(256);
        client.dispatcher().setMaxRequestsPerHost(64);
        compressingClient.dispatcher().setMaxRequests(64);
        compressingClient.dispatcher().setMaxRequestsPerHost(8);
    }

    public static Response makeCall(AbstractHTTPConnectionConfigurable connectionConfig, Request request) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        return HttpConnectionManager.makeCall(connectionConfig, request, false, null);
    }

    public static Response makeCompressedCall(AbstractHTTPConnectionConfigurable connectionConfig, Request request) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        return HttpConnectionManager.makeCall(connectionConfig, request, true, null);
    }

    public static Response makeCall(AbstractHTTPConnectionConfigurable connectionConfig, Request request, boolean compressCall) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        return HttpConnectionManager.makeCall(connectionConfig, request, compressCall, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Response makeCall(AbstractHTTPConnectionConfigurable connectionConfig, Request request, boolean compressCall, CookieJar cookieJar) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        int rateLimit = connectionConfig.getRateLimit();
        if (rateLimit > 0) {
            ConcurrentHashMap<String, Long> concurrentHashMap = lastAccessMap;
            synchronized (concurrentHashMap) {
                Long lastAccess = lastAccessMap.get(connectionConfig.getBaseURL());
                long currentTime = System.currentTimeMillis();
                if (lastAccess != null) {
                    long nextTime = lastAccess + (long)rateLimit;
                    while (currentTime < nextTime) {
                        try {
                            Thread.sleep(nextTime - currentTime);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        currentTime = System.currentTimeMillis();
                    }
                }
                lastAccessMap.put(connectionConfig.getBaseURL(), currentTime);
            }
        }
        Request.Builder requestBuilder = request.newBuilder();
        if (connectionConfig.getAuthenticationMethod() == AbstractHTTPConnectionConfigurable.AUTHENTICATION_BASIC) {
            requestBuilder.header("Authorization", Credentials.basic(connectionConfig.getUser(), connectionConfig.getPassword()));
        }
        if (!connectionConfig.isCacheEnabled()) {
            CacheControl.Builder cacheControlBuilder = new CacheControl.Builder().noCache().noStore().noTransform();
            requestBuilder.cacheControl(cacheControlBuilder.build());
        }
        request = requestBuilder.build();
        OkHttpClient.Builder clientBuilder = compressCall ? compressingClient.newBuilder() : client.newBuilder();
        if (cookieJar != null) {
            clientBuilder.cookieJar(cookieJar);
        }
        clientBuilder.connectTimeout(connectionConfig.getConnectTimeout(), TimeUnit.SECONDS);
        clientBuilder.readTimeout(connectionConfig.getResponseTimeout(), TimeUnit.SECONDS);
        String baseUrl = connectionConfig.getBaseURL();
        if (baseUrl != null && baseUrl.toLowerCase().startsWith("https") && connectionConfig.addCertificate()) {
            String passphrase = connectionConfig.getPassphrase();
            if (passphrase == null) {
                passphrase = "";
            }
            KeyStore keyStore = KeyStore.getInstance(connectionConfig.getCertificateType());
            try (FileInputStream in = new FileInputStream(connectionConfig.getCertificate());){
                keyStore.load(in, passphrase.toCharArray());
            }
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, passphrase.toCharArray());
            KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            Object[] trustManagers = trustManagerFactory.getTrustManagers();
            if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
                throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
            }
            X509TrustManager trustManager = (X509TrustManager)trustManagers[0];
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(keyManagers, null, new SecureRandom());
            SSLContext.setDefault(sslContext);
            return clientBuilder.sslSocketFactory(sslContext.getSocketFactory(), trustManager).build().newCall(request).execute();
        }
        return clientBuilder.build().newCall(request).execute();
    }

    static {
        lastAccessMap = new ConcurrentHashMap();
    }
}

