/*
 * Decompiled with CFR 0.152.
 */
package com.owc.io.http;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;

public class SimpleCookieJar
implements CookieJar {
    private Map<HttpUrl, List<Cookie>> storedCookies = new LinkedHashMap<HttpUrl, List<Cookie>>();

    public SimpleCookieJar() {
    }

    private SimpleCookieJar(Map<HttpUrl, List<Cookie>> storedCookies) {
        this.storedCookies = storedCookies;
    }

    @Override
    public void saveFromResponse(HttpUrl url, List<Cookie> cookies) {
        this.storedCookies.put(url, cookies);
    }

    @Override
    public List<Cookie> loadForRequest(HttpUrl url) {
        LinkedList<Cookie> validCookies = new LinkedList<Cookie>();
        for (Map.Entry<HttpUrl, List<Cookie>> entry : this.storedCookies.entrySet()) {
            for (Cookie cookie : entry.getValue()) {
                if (cookie.expiresAt() <= System.currentTimeMillis()) continue;
                validCookies.add(cookie);
            }
        }
        return validCookies;
    }

    public Map<HttpUrl, List<Cookie>> getStoredCookies() {
        return this.storedCookies;
    }

    public void resetStoredCookies() {
        this.storedCookies.clear();
    }

    public void storeCookie(HttpUrl url, Cookie setCookie) {
        List<Cookie> list = this.storedCookies.get(url);
        if (list == null) {
            list = new LinkedList<Cookie>();
            this.storedCookies.put(url, list);
        }
        list.add(setCookie);
    }

    public SimpleCookieJar clone() {
        return new SimpleCookieJar(this.storedCookies);
    }
}

