/*
 * Decompiled with CFR 0.152.
 */
package com.owc.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.owc.json.actions.ParseAction;
import com.owc.json.actions.PathElement;
import com.owc.tools.ExampleSetCreator;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.UserError;
import com.rapidminer.tools.container.Pair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;

public class Parser {
    public LinkedHashMap<Integer, ExampleSet> parse(JsonParser parser, Map<Integer, ExampleSetCreator> creators, ArrayList<ParseAction> parseActions, ArrayList<ParseAction> leaveActions, Map<Pair<ParseAction, Integer>, Integer> rowAffectionScopes) throws JsonParseException, IOException, UserError {
        Stack<PathElement> stack = new Stack<PathElement>();
        JsonToken token = parser.nextToken();
        while (token != null) {
            switch (token) {
                case START_ARRAY: {
                    stack.push(new PathElement("["));
                    this.checkActions(parser, creators, parseActions, stack, rowAffectionScopes);
                    break;
                }
                case START_OBJECT: {
                    stack.push(new PathElement("{"));
                    this.checkActions(parser, creators, parseActions, stack, rowAffectionScopes);
                    break;
                }
                case END_ARRAY: 
                case END_OBJECT: {
                    this.checkActions(parser, creators, leaveActions, stack, rowAffectionScopes);
                    stack.pop();
                    if (stack.isEmpty() || stack.peek().equals(PathElement.ARRAY_ELEMENT)) break;
                    stack.pop();
                    break;
                }
                case FIELD_NAME: {
                    stack.push(new PathElement(parser.getText()));
                    this.checkActions(parser, creators, parseActions, stack, rowAffectionScopes);
                    this.checkActions(parser, creators, leaveActions, stack, rowAffectionScopes);
                    break;
                }
                default: {
                    stack.push(new PathElement("#"));
                    this.checkActions(parser, creators, parseActions, stack, rowAffectionScopes);
                    this.checkActions(parser, creators, leaveActions, stack, rowAffectionScopes);
                    stack.pop();
                    if (stack.isEmpty() || stack.peek().equals(PathElement.ARRAY_ELEMENT)) break;
                    stack.pop();
                }
            }
            if (stack.isEmpty()) {
                for (Map.Entry<Integer, ExampleSetCreator> entry : creators.entrySet()) {
                    entry.getValue().resetRow();
                }
            }
            token = parser.nextToken();
        }
        LinkedHashMap<Integer, ExampleSet> sets = new LinkedHashMap<Integer, ExampleSet>();
        for (Map.Entry<Integer, ExampleSetCreator> creatorsEntry : creators.entrySet()) {
            sets.put(creatorsEntry.getKey(), creatorsEntry.getValue().finish());
        }
        return sets;
    }

    protected void checkActions(JsonParser parser, Map<Integer, ExampleSetCreator> creators, ArrayList<ParseAction> actions, Stack<PathElement> stack, Map<Pair<ParseAction, Integer>, Integer> rowAffectionScopes) throws IOException, UserError {
        for (int i = 0; i < actions.size(); ++i) {
            ParseAction parseAction = actions.get(i);
            PathElement[] path = parseAction.getPath();
            if (path.length != stack.size()) continue;
            boolean fits = true;
            for (int j = path.length - 1; j >= 0; --j) {
                if (path[j].equals(stack.get(j))) continue;
                fits = false;
                break;
            }
            if (!fits) continue;
            parseAction.trigger(parser, creators, rowAffectionScopes);
        }
    }
}

