/*
 * Decompiled with CFR 0.152.
 */
package com.owc.json.actions;

import com.fasterxml.jackson.core.JsonParser;
import com.owc.json.actions.ParseAction;
import com.owc.json.actions.PathElement;
import com.owc.tools.ExampleSetCreator;
import com.rapidminer.tools.container.Pair;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;

public class CommitParseAction
implements ParseAction {
    private static final long serialVersionUID = -5603613292370335617L;
    private Integer setID;
    private PathElement[] path;

    public CommitParseAction(PathElement[] path) {
        this.path = path;
    }

    @Override
    public void trigger(JsonParser jsonParser, Map<Integer, ExampleSetCreator> creators, Map<Pair<ParseAction, Integer>, Integer> rowAffectionScope) throws IOException {
        creators.get(this.setID).commitAndKeep();
    }

    public String toString() {
        if (this.setID == null) {
            return "commit at " + PathElement.toString(this.path);
        }
        return "commit (" + this.setID + ") at " + PathElement.toString(this.path);
    }

    @Override
    public PathElement[] getPath() {
        return this.path;
    }

    @Override
    public void setSetID(int id) {
        this.setID = id;
    }

    @Override
    public int getSetID() {
        return this.setID;
    }

    @Override
    public ParseAction clone() {
        return new CommitParseAction(Arrays.copyOf(this.path, this.path.length));
    }
}

