/*
 * Decompiled with CFR 0.152.
 */
package com.owc.json.actions;

import java.io.Serializable;

public class PathElement
implements Serializable {
    private static final long serialVersionUID = 9052030372853645363L;
    public static final PathElement ARRAY_ELEMENT = new PathElement("[");
    public static final PathElement OBJECT_ELEMENT = new PathElement("{");
    public static final PathElement VALUE_ELEMENT = new PathElement("#");
    private String element;

    public PathElement(String element) {
        this.element = element;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.element == null ? 0 : this.element.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathElement other = (PathElement)obj;
        return !(this.element == null ? other.element != null : !this.element.equals(other.element));
    }

    public String toString() {
        return this.element;
    }

    public static String toString(PathElement[] path) {
        StringBuilder builder = new StringBuilder();
        for (PathElement element : path) {
            if (element == ARRAY_ELEMENT || element == OBJECT_ELEMENT || element == VALUE_ELEMENT) {
                builder.append(element.toString());
                builder.append(" ");
                continue;
            }
            builder.append(element.toString());
            builder.append(":");
        }
        return builder.toString();
    }
}

