/*
 * Decompiled with CFR 0.152.
 */
package com.owc.json.actions;

import com.fasterxml.jackson.core.JsonParser;
import com.owc.json.actions.ParseAction;
import com.owc.json.actions.PathElement;
import com.owc.tools.ExampleSetCreator;
import com.rapidminer.tools.container.Pair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ResetRowParseAction
implements ParseAction {
    private static final long serialVersionUID = -5603613292370335617L;
    private Integer setID;
    private PathElement[] path;
    private List<String> resetAttributeNames;

    public ResetRowParseAction(PathElement[] path, List<String> resetAttributeNames) {
        this.path = path;
        this.resetAttributeNames = resetAttributeNames;
    }

    @Override
    public void trigger(JsonParser jsonParser, Map<Integer, ExampleSetCreator> creators, Map<Pair<ParseAction, Integer>, Integer> rowAffectionScope) throws IOException {
        ExampleSetCreator creator = creators.get(this.setID);
        for (String attributeName : this.resetAttributeNames) {
            creator.resetValue(attributeName);
        }
    }

    public String toString() {
        if (this.setID == null) {
            return "reset " + this.resetAttributeNames.toString() + "at " + PathElement.toString(this.path);
        }
        return "reset " + this.resetAttributeNames.toString() + " (" + this.setID + ") at " + PathElement.toString(this.path);
    }

    @Override
    public PathElement[] getPath() {
        return this.path;
    }

    @Override
    public void setSetID(int id) {
        this.setID = id;
    }

    @Override
    public int getSetID() {
        return this.setID;
    }

    @Override
    public ParseAction clone() {
        return new ResetRowParseAction(Arrays.copyOf(this.path, this.path.length), new ArrayList<String>(this.resetAttributeNames));
    }
}

