/*
 * Decompiled with CFR 0.152.
 */
package com.owc.objects;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.owc.objects.JSONSerializableIOObject;
import com.rapidminer.operator.ResultObjectAdapter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class AbstractJSONSerializableObject
extends ResultObjectAdapter
implements JSONSerializableIOObject {
    @Override
    public void serializeAsJSON(OutputStream outputStream) throws JsonGenerationException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.writeValue(outputStream, this.getPayload());
        outputStream.flush();
    }

    @Override
    public String serializeAsJSON() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ObjectMapper mapper = new ObjectMapper();
        mapper.writeValue((OutputStream)outputStream, this.getPayload());
        outputStream.flush();
        return new String(outputStream.toByteArray());
    }

    protected abstract Object getPayload();

    public String toResultString() {
        try {
            return this.serializeAsJSON();
        }
        catch (IOException e) {
            return e.getMessage();
        }
    }
}

