/*
 * Decompiled with CFR 0.152.
 */
package com.owc.objects;

import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.nio.file.FileObject;
import com.rapidminer.tools.Tools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class AbstractTemporaryFileObject
extends FileObject {
    private static final String TEMP_FILE_PREFIX = "rm_fileobject_";
    private static final String TEMP_FILE_SUFFIX = ".temp";
    private File temporaryFile = null;

    public final InputStream openStream() throws OperatorException {
        if (this.temporaryFile != null) {
            try {
                return new FileInputStream(this.temporaryFile);
            }
            catch (FileNotFoundException e) {
                throw new OperatorException("303", (Throwable)e, new Object[]{this.temporaryFile, e.getMessage()});
            }
        }
        return this.openSourceStream();
    }

    public final File getFile() throws OperatorException {
        if (this.temporaryFile == null) {
            try {
                this.temporaryFile = File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX);
                this.temporaryFile.deleteOnExit();
            }
            catch (IOException e) {
                throw new OperatorException("303", (Throwable)e, new Object[]{"File in " + System.getProperty("java.io.tmpdir"), e.getMessage()});
            }
            try (FileOutputStream fos = new FileOutputStream(this.temporaryFile);
                 InputStream in = this.openSourceStream();){
                Tools.copyStreamSynchronously((InputStream)in, (OutputStream)fos, (boolean)true);
            }
            catch (IOException e) {
                throw new OperatorException("303", (Throwable)e, new Object[]{this.temporaryFile, e.getMessage()});
            }
        }
        return this.temporaryFile;
    }

    public final long getLength() throws OperatorException {
        return this.getFile().length();
    }

    public abstract InputStream openSourceStream() throws OperatorException;
}

