/*
 * Decompiled with CFR 0.152.
 */
package com.owc.objects;

import com.owc.json.actions.ParseAction;
import com.owc.json.actions.PathElement;
import com.owc.tools.ExampleSetCreator;
import com.owc.tools.ExampleSetCreatorBuilder;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.ResultObjectAdapter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;

public class JSONParserSpecificationObject
extends ResultObjectAdapter {
    private static final long serialVersionUID = -8614567753003430868L;
    private static final AtomicInteger COUNTER = new AtomicInteger(0);
    private ExampleSetCreatorBuilder exampleSetCreatorBuilder = new ExampleSetCreatorBuilder();
    private LinkedList<ParseAction> actions = new LinkedList();
    private LinkedList<ParseAction> leaveActions = new LinkedList();
    private Stack<PathElement> stack = new Stack();
    private transient int id = COUNTER.incrementAndGet();

    public JSONParserSpecificationObject() {
    }

    private JSONParserSpecificationObject(ExampleSetCreatorBuilder exampleSetCreatorBuilder, Stack<PathElement> stack, LinkedList<ParseAction> actions, LinkedList<ParseAction> leaveActions) {
        this();
        this.exampleSetCreatorBuilder = exampleSetCreatorBuilder;
        this.stack = stack;
        this.leaveActions = leaveActions;
        this.actions = actions;
    }

    public void addAction(ParseAction action) {
        this.actions.add(action);
    }

    public void addLeaveAction(ParseAction action) {
        this.leaveActions.add(action);
    }

    public ExampleSetCreatorBuilder getExampleSetCreatorBuilder() {
        return this.exampleSetCreatorBuilder;
    }

    public IOObject copy() {
        Stack<PathElement> stack2 = new Stack<PathElement>();
        stack2.addAll(this.stack);
        LinkedList<ParseAction> actions = new LinkedList<ParseAction>();
        for (ParseAction action : this.actions) {
            actions.add(action.clone());
        }
        LinkedList<ParseAction> leaveActions = new LinkedList<ParseAction>();
        for (ParseAction action : this.leaveActions) {
            leaveActions.add(action.clone());
        }
        return new JSONParserSpecificationObject(this.exampleSetCreatorBuilder.clone(), stack2, actions, leaveActions);
    }

    public void pushContextPathElement(PathElement element) {
        this.stack.push(element);
    }

    public void popContextPathElement() {
        this.stack.pop();
    }

    public PathElement[] getPath(PathElement ... children) {
        PathElement[] path = new PathElement[this.stack.size() + children.length];
        this.stack.toArray(path);
        for (int i = 0; i < children.length; ++i) {
            path[this.stack.size() + i] = children[i];
        }
        return path;
    }

    public List<ParseAction> getParseActions() {
        for (ParseAction action : this.actions) {
            action.setSetID(this.id);
        }
        return this.actions;
    }

    public List<ParseAction> getLeaveActions() {
        LinkedList<ParseAction> reversedLeaveActions = new LinkedList<ParseAction>();
        for (ParseAction action : this.leaveActions) {
            action.setSetID(this.id);
            reversedLeaveActions.push(action);
        }
        return reversedLeaveActions;
    }

    public ExampleSetCreator getExampleSetCreator() {
        return this.exampleSetCreatorBuilder.build();
    }

    public int getID() {
        return this.id;
    }

    public PathElement[] getCurrentPath() {
        return this.stack.toArray(new PathElement[this.stack.size()]);
    }

    public String toResultString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Object Number: " + this.id + "\n");
        builder.append("Current Path: ");
        builder.append(this.stack.toString());
        builder.append("\n");
        builder.append("\n");
        builder.append("Parse Actions\n");
        for (ParseAction action : this.getParseActions()) {
            builder.append(action.toString());
            builder.append("\n");
        }
        builder.append("\n");
        builder.append("Leave Actions\n");
        for (ParseAction action : this.getLeaveActions()) {
            builder.append(action.toString());
            builder.append("\n");
        }
        return builder.toString();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.id = COUNTER.incrementAndGet();
    }
}

