/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.owc.license.ProductInformation;
import com.owc.metadata.JSONParserSpecificationMetaData;
import com.owc.objects.JSONParserSpecificationObject;
import com.owc.operator.LicensedOperator;
import com.owc.process.ports.NamedOneToOneExtender;
import com.owc.process.ports.NamedPortPairExtender;
import com.owc.tools.JSONTools;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.PluginInitWebAutomationExtension;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.nio.file.FileObject;
import com.rapidminer.operator.nio.file.SimpleFileObject;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.operator.ports.metadata.SimplePrecondition;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.PortProvider;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.parameter.conditions.PortConnectedCondition;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

public class ParseJSONFileOperator
extends LicensedOperator {
    private static final String PARAMETER_FILE = "file";
    private static JsonFactory JSON_FACTORY = new JsonFactory();
    private InputPort fileObjectInputPort = (InputPort)this.getInputPorts().createPort("file object");
    private NamedOneToOneExtender parseSpecificationExtender = new NamedOneToOneExtender("parse specifications", "example set", this.getInputPorts(), this.getOutputPorts());

    public ParseJSONFileOperator(OperatorDescription description) {
        super(description);
        this.fileObjectInputPort.addPrecondition((Precondition)new SimplePrecondition(this.fileObjectInputPort, new MetaData(FileObject.class), false));
        this.parseSpecificationExtender.start();
        this.getTransformer().addRule(new MDTransformationRule(){

            public void transformMD() {
                for (NamedPortPairExtender.NamedPortPair pair : ParseJSONFileOperator.this.parseSpecificationExtender.getManagedPairs()) {
                    if (!pair.getInputPort().isConnected()) continue;
                    MetaData metaData = pair.getInputPort().getMetaData();
                    if (metaData != null && metaData instanceof JSONParserSpecificationMetaData) {
                        JSONParserSpecificationMetaData specMd = (JSONParserSpecificationMetaData)metaData.clone();
                        pair.getOutputPort().deliverMD((MetaData)specMd.getExampleSetDefinition());
                        continue;
                    }
                    pair.getOutputPort().deliverMD((MetaData)new ExampleSetMetaData());
                }
            }
        });
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        if (!isLicensed) {
            throw new UserError((Operator)this, "toolkit.license_exceeded_functionality");
        }
        List<JSONParserSpecificationObject> parserSpecifications = this.parseSpecificationExtender.getData(JSONParserSpecificationObject.class);
        Object fileObject = this.fileObjectInputPort.isConnected() ? (FileObject)this.fileObjectInputPort.getData(FileObject.class) : new SimpleFileObject(this.getParameterAsFile(PARAMETER_FILE));
        try (JsonParser jsonParser = JSON_FACTORY.createParser(fileObject.openStream());){
            LinkedHashMap<Integer, ExampleSet> sets = JSONTools.parseJSON(parserSpecifications, jsonParser);
            this.parseSpecificationExtender.deliver(new LinkedList<ExampleSet>(sets.values()));
        }
        catch (JsonParseException e) {
            throw new OperatorException("web_automation.illegal_json", null, new Object[0]);
        }
        catch (IOException e) {
            throw new OperatorException("web_automation.io_error", null, new Object[0]);
        }
        catch (UserError e) {
            e.setOperator((Operator)this);
            throw e;
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeFile type = new ParameterTypeFile(PARAMETER_FILE, "The file containing the JSON encoded data. Alternatively you can use the file object input port.", true, new String[]{"json"});
        type.setExpert(false);
        type.registerDependencyCondition((ParameterCondition)new PortConnectedCondition((ParameterHandler)this, new PortProvider(){

            public Port getPort() {
                return ParseJSONFileOperator.this.fileObjectInputPort;
            }
        }, true, false));
        types.add((ParameterType)type);
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitWebAutomationExtension.PRODUCT_INFORMATION;
    }
}

