/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.loops;

import com.owc.operator.ParallelOperatorChain;
import com.owc.process.ports.CollectingOneToOneExtender;
import com.owc.process.ports.OneToManyExtender;
import com.owc.process.ports.OneToOneExtender;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.OutputPorts;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.SubprocessTransformRule;
import java.util.List;

public abstract class ParallelLoopingOperatorChain
extends ParallelOperatorChain {
    protected final CollectingOneToOneExtender outputExtender = new CollectingOneToOneExtender("output collector", this.getSubprocess(0).getInnerSinks(), this.getOutputPorts());
    protected final OneToManyExtender loopExtender = new OneToManyExtender("loop", this.getSubprocess(0).getInnerSinks(), new OutputPorts[]{this.getSubprocess(0).getInnerSources(), this.getOutputPorts()});
    protected final OneToOneExtender inputExtender = new OneToOneExtender("in", this.getInputPorts(), this.getSubprocess(0).getInnerSources());

    public ParallelLoopingOperatorChain(OperatorDescription description, String ... subprocessNames) {
        super(description, subprocessNames);
        this.loopExtender.start();
        this.inputExtender.start();
        this.outputExtender.start();
        this.getTransformer().addRule(this.inputExtender.makePassThroughRule());
        this.getTransformer().addRule(new MDTransformationRule(){

            public void transformMD() {
                List<OneToManyExtender.PortRow> portRows = ParallelLoopingOperatorChain.this.loopExtender.getPortRows();
                int i = 0;
                for (OneToOneExtender.PortPair pair : ParallelLoopingOperatorChain.this.inputExtender.getManagedPairs()) {
                    MetaData inData = pair.getInputPort().getMetaData();
                    if (i >= portRows.size()) continue;
                    for (OutputPort outputPort : portRows.get(i++).getOutputPorts()) {
                        if (inData != null) {
                            inData = inData.clone();
                            inData.addToHistory(outputPort);
                        }
                        outputPort.deliverMD(inData);
                    }
                }
            }
        });
        this.getTransformer().addRule((MDTransformationRule)new SubprocessTransformRule(this.getSubprocess(0)));
        this.getTransformer().addRule(this.loopExtender.makePassThroughRule());
        this.getTransformer().addRule(this.outputExtender.makePassThroughRule());
    }

    @Override
    public final void doWork(boolean isLicensed) throws OperatorException {
        this.outputExtender.reset();
        this.doWork(isLicensed, this.checkParallelizability());
    }

    public abstract void doWork(boolean var1, boolean var2) throws OperatorException;

    @Override
    protected boolean checkParallelizability() {
        return super.checkParallelizability() & !this.loopExtender.isConnected();
    }
}

