/*
 * Decompiled with CFR 0.152.
 */
package com.owc.cryptography;

import com.owc.tools.Base64Tools;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class CryptographyService {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    public static final String SIGNATURE_METHOD_PROPERTY = "opa_tad.signature_method";
    public static final String DEFAULT_SIGNATURE_METHOD = "SHA256withRSA";
    public static final String SIGNATURE_ALGORITHM_PROPERTY = "opa_tad.signature_algorithm";
    public static final String DEFAULT_SIGNATURE_ALGORITHM = "RSA";
    public static final int SIGNATURE_MIN_KEY_LENGTH = 2048;
    public static final String HASH_METHOD_PROPERTY = "opa_tad.hash_method";
    public static final String DEFAULT_HASH_METHOD = "SHA-256";
    public static final String ASYMMETRIC_ALGORITHM_PROPERTY = "opa_tad.asymetric_algorithm";
    public static final String DEFAULT_ASYMMETRIC_ALGORITHM = "RSA";
    public static final int ASYMMETRIC_MIN_KEY_LENGTH = 2048;
    public static final String ASYMMETRIC_METHOD_PROPERTY = "opa_tad.asymetric_encoding_method";
    public static final String DEFAULT_ENCODING_METHOD = "RSA/ECB/OAEPWithSHA1AndMGF1Padding";
    public static final String SYMMETRIC_ALGORITHM_PROPERTY = "opa_tad.symetric_algorithm";
    public static final String DEFAULT_SYMMETRIC_ALGORITHM = "AES";
    public static final int SYMMETRIC_MIN_KEY_LENGTH = 256;
    public static final String SYMMETRIC_METHOD_PROPERTY = "opa_tad.symetric_method";
    public static final String DEFAULT_SYMMETRIC_METHOD = "AES/GCM/NoPadding";

    public static PublicKey derivePublicKey(String base64EncodedKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(Base64Tools.decode(base64EncodedKey));
        KeyFactory keyFactory = KeyFactory.getInstance(CryptographyService.getAsymmetricMethod());
        return keyFactory.generatePublic(publicKeySpec);
    }

    public static PrivateKey derivePrivateKey(String base64EncodedKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(Base64Tools.decode(base64EncodedKey));
        KeyFactory keyFactory = KeyFactory.getInstance(CryptographyService.getAsymmetricMethod());
        return keyFactory.generatePrivate(publicKeySpec);
    }

    public static MessageDigest deriveMessageDigest() throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(CryptographyService.getHashMethod());
    }

    private static String getSymmetricAlgorithm() {
        String method = System.getProperty(SYMMETRIC_ALGORITHM_PROPERTY);
        if (method == null) {
            return DEFAULT_SYMMETRIC_ALGORITHM;
        }
        return method;
    }

    private static String getSymmetricMethod() {
        String method = System.getProperty(SYMMETRIC_METHOD_PROPERTY);
        if (method == null) {
            return DEFAULT_SYMMETRIC_METHOD;
        }
        return method;
    }

    private static int getSymmetricKeyLength() {
        return 256;
    }

    private static String getAsymmetricMethod() {
        String method = System.getProperty(ASYMMETRIC_ALGORITHM_PROPERTY);
        if (method == null) {
            return "RSA";
        }
        return method;
    }

    private static int getAsymmetricKeyLength() {
        return 2048;
    }

    private static int getSignatureKeyLength() {
        return 2048;
    }

    private static String getAsymmetricEncodingMethod() {
        String method = System.getProperty(ASYMMETRIC_METHOD_PROPERTY);
        if (method == null) {
            return DEFAULT_ENCODING_METHOD;
        }
        return method;
    }

    public static Cipher deriveAsymmetricEncodingCipher(PublicKey publicKey) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException {
        Cipher cipher = Cipher.getInstance(CryptographyService.getAsymmetricEncodingMethod());
        cipher.init(1, publicKey);
        return cipher;
    }

    public static Cipher deriveAsymmetricDecodingCipher(PrivateKey privateKey) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException {
        Cipher cipher = Cipher.getInstance(CryptographyService.getAsymmetricEncodingMethod());
        cipher.init(2, privateKey);
        return cipher;
    }

    public static boolean isPublicEncodingKeyCompatible(PublicKey publicKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return CryptographyService.getKeyLength(publicKey) >= 2048;
    }

    private static String getHashMethod() {
        String method = System.getProperty(HASH_METHOD_PROPERTY);
        if (method == null) {
            return DEFAULT_HASH_METHOD;
        }
        return method;
    }

    public static Signature deriveSignatureVerifier(PublicKey signaturePublicKey) throws NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException {
        Signature instance = Signature.getInstance(CryptographyService.getSignatureMethod());
        instance.initVerify(signaturePublicKey);
        return instance;
    }

    public static Signature deriveSignatureSigner(PrivateKey signaturePrivateKey) throws NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException {
        Signature instance = Signature.getInstance(CryptographyService.getSignatureMethod());
        instance.initSign(signaturePrivateKey);
        return instance;
    }

    public static boolean isSignatureKeyCompatible(PublicKey signaturePublicKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return CryptographyService.getKeyLength(signaturePublicKey) >= 2048;
    }

    private static String getSignatureMethod() {
        String method = System.getProperty(SIGNATURE_METHOD_PROPERTY);
        if (method == null) {
            return DEFAULT_SIGNATURE_METHOD;
        }
        return method;
    }

    private static String getSignatureAlgorithm() {
        String method = System.getProperty(SIGNATURE_ALGORITHM_PROPERTY);
        if (method == null) {
            return "RSA";
        }
        return method;
    }

    public static int getKeyLength(PublicKey pk) {
        int len = -1;
        if (pk instanceof RSAPublicKey) {
            RSAPublicKey rsapub = (RSAPublicKey)pk;
            len = rsapub.getModulus().bitLength();
        } else if (pk instanceof ECPublicKey) {
            ECPublicKey ecpriv = (ECPublicKey)pk;
            ECParameterSpec spec = ecpriv.getParams();
            len = spec != null ? spec.getOrder().bitLength() : 0;
        } else if (pk instanceof DSAPublicKey) {
            DSAPublicKey dsapub = (DSAPublicKey)pk;
            len = dsapub.getParams() != null ? dsapub.getParams().getP().bitLength() : dsapub.getY().bitLength();
        }
        return len;
    }

    public static KeyPair generateAsymmetricKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(CryptographyService.getAsymmetricMethod());
        keyPairGenerator.initialize(CryptographyService.getAsymmetricKeyLength());
        return keyPairGenerator.genKeyPair();
    }

    public static KeyPair generateSignatureKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(CryptographyService.getSignatureAlgorithm());
        keyPairGenerator.initialize(CryptographyService.getSignatureKeyLength());
        return keyPairGenerator.genKeyPair();
    }

    public static SecretKey deriveSymmetricSecret(byte[] key) {
        return new SecretKeySpec(key, CryptographyService.getSymmetricAlgorithm());
    }

    public static Cipher deriveSymmetricEncodingCipher(SecretKey secretKey) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException {
        return Cipher.getInstance(CryptographyService.getSymmetricMethod());
    }

    public static Cipher deriveSymmetricDecodingCipher(SecretKey secretKey) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException {
        return Cipher.getInstance(CryptographyService.getSymmetricMethod());
    }

    public static Cipher initSymmetricEncodingCipher(Cipher cipher, SecretKey key, byte[] currentRowIV) throws InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException {
        if (cipher == null) {
            cipher = CryptographyService.deriveSymmetricEncodingCipher(key);
        }
        GCMParameterSpec parameterSpec = new GCMParameterSpec(128, currentRowIV);
        cipher.init(1, (Key)key, parameterSpec);
        return cipher;
    }

    public static Cipher initSymmetricDecodingCipher(Cipher cipher, SecretKey key, byte[] currentRowIV) throws InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException {
        if (cipher == null) {
            cipher = CryptographyService.deriveSymmetricDecodingCipher(key);
        }
        GCMParameterSpec parameterSpec = new GCMParameterSpec(128, currentRowIV);
        cipher.init(2, (Key)key, parameterSpec);
        return cipher;
    }
}

