/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.wizards;

import com.owc.license.License;
import com.owc.license.LicenseManager;
import com.owc.license.ProductInformation;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.tools.ParameterService;
import java.awt.AWTPermission;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessControlException;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LicenseKeyActivationDialog
extends ButtonDialog {
    private static final String TEXT_YOUR_EMAIL_ADDRESS = "Enter your email address here";
    private static final String TEXT_YOUR_ACTIVATION_KEY = "Paste your activation key here";
    private static final long serialVersionUID = 1L;
    private JPanel centerComponent = new JPanel();
    private JTextField emailField = new JTextField("Enter your email address here");
    private JTextField keyField = new JTextField("Paste your activation key here");
    private JLabel validityLabel = new JLabel("Please enter your email and activation key above.");
    private boolean isClipboardAccessible = true;
    private ProductInformation productInformation;

    public LicenseKeyActivationDialog(ParameterType type, String key, ProductInformation productInformation) {
        super(null, "activate_license", Dialog.ModalityType.APPLICATION_MODAL, new Object[]{productInformation.getProductName()});
        JButton okButton = this.makeOkButton();
        if (System.getSecurityManager() != null) {
            try {
                System.getSecurityManager().checkPermission(new AWTPermission("accessClipboard"));
            }
            catch (SecurityException e) {
                this.validityLabel.setText("Access to clipboard forbidden for extensions by RapidMiner Security mechanism. Please go to RapidMiner preferences, Licenses tab and enter license data there.");
                this.validityLabel.setForeground(Color.red);
                okButton.setEnabled(false);
                this.keyField.setEnabled(false);
                this.emailField.setEnabled(false);
            }
        }
        this.productInformation = productInformation;
        String licenseKey = ParameterService.getParameterValue((String)(productInformation.getProductName() + ".license_key"));
        String emailAddress = ParameterService.getParameterValue((String)(productInformation.getProductName() + ".email"));
        if (emailAddress == null || emailAddress.isEmpty()) {
            this.emailField.setForeground(Color.gray);
        } else {
            this.emailField.setText(emailAddress);
        }
        if (licenseKey == null || licenseKey.isEmpty()) {
            try {
                String data = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
                if (data != null && !data.isEmpty()) {
                    this.keyField.setText(data);
                }
            }
            catch (HeadlessException data) {
            }
            catch (UnsupportedFlavorException data) {
            }
            catch (IOException data) {
            }
            catch (AccessControlException data) {
                // empty catch block
            }
        }
        this.emailField.setMaximumSize(new Dimension(200, 100));
        this.emailField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                if (LicenseKeyActivationDialog.this.emailField.getText().isEmpty() || LicenseKeyActivationDialog.this.emailField.getText().equals(LicenseKeyActivationDialog.TEXT_YOUR_EMAIL_ADDRESS)) {
                    LicenseKeyActivationDialog.this.emailField.setText(LicenseKeyActivationDialog.TEXT_YOUR_EMAIL_ADDRESS);
                    LicenseKeyActivationDialog.this.emailField.setForeground(Color.gray);
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (LicenseKeyActivationDialog.this.emailField.getText().equals(LicenseKeyActivationDialog.TEXT_YOUR_EMAIL_ADDRESS) || LicenseKeyActivationDialog.this.emailField.getText().equals(LicenseKeyActivationDialog.TEXT_YOUR_ACTIVATION_KEY)) {
                    LicenseKeyActivationDialog.this.emailField.setText("");
                    LicenseKeyActivationDialog.this.emailField.setForeground(Color.black);
                }
            }
        });
        if (licenseKey == null || licenseKey.isEmpty()) {
            this.keyField.setForeground(Color.gray);
        } else {
            this.keyField.setText(licenseKey);
        }
        this.keyField.setColumns(80);
        this.keyField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                if (LicenseKeyActivationDialog.this.keyField.getText().isEmpty()) {
                    LicenseKeyActivationDialog.this.keyField.setText(LicenseKeyActivationDialog.TEXT_YOUR_ACTIVATION_KEY);
                    LicenseKeyActivationDialog.this.keyField.setForeground(Color.gray);
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (LicenseKeyActivationDialog.this.keyField.getText().equals(LicenseKeyActivationDialog.TEXT_YOUR_ACTIVATION_KEY)) {
                    LicenseKeyActivationDialog.this.keyField.setText("");
                    LicenseKeyActivationDialog.this.keyField.setForeground(Color.black);
                }
            }
        });
        this.emailField.getDocument().addDocumentListener(new LicenseCheckingDocumentListener());
        this.keyField.getDocument().addDocumentListener(new LicenseCheckingDocumentListener());
        GridLayout layout = new GridLayout(3, 1);
        layout.setHgap(10);
        layout.setVgap(10);
        this.centerComponent.setLayout(layout);
        this.centerComponent.add(this.emailField);
        this.centerComponent.add(this.keyField);
        this.centerComponent.add(this.validityLabel);
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            ResourceAction orderAction = new ResourceAction("owc.order_license", new Object[0]){
                private static final long serialVersionUID = 1232L;

                public void actionPerformed(ActionEvent e) {
                    try {
                        Desktop.getDesktop().browse(new URI("https://oldworldcomputing.com/en/shop/"));
                    }
                    catch (IOException iOException) {
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                }
            };
            this.layoutDefault(this.centerComponent, new AbstractButton[]{okButton, this.makeCancelButton(), new JButton((Action)orderAction)});
        } else {
            this.layoutDefault(this.centerComponent, new AbstractButton[]{okButton, this.makeCancelButton()});
        }
    }

    protected void ok() {
        ParameterService.setParameterValue((String)(this.productInformation.getProductName() + ".email"), (String)this.emailField.getText());
        ParameterService.setParameterValue((String)(this.productInformation.getProductName() + ".license_key"), (String)this.keyField.getText());
        ParameterService.saveParameters();
        LicenseManager.update(this.productInformation.getProductName());
        super.ok();
    }

    private class LicenseCheckingDocumentListener
    implements DocumentListener {
        private LicenseCheckingDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update();
        }

        private void update() {
            try {
                if (!(LicenseKeyActivationDialog.this.keyField.getText().isEmpty() || LicenseKeyActivationDialog.this.keyField.getText().equals(LicenseKeyActivationDialog.TEXT_YOUR_ACTIVATION_KEY) || LicenseKeyActivationDialog.this.emailField.getText().isEmpty() || LicenseKeyActivationDialog.this.emailField.getText().equals(LicenseKeyActivationDialog.TEXT_YOUR_EMAIL_ADDRESS))) {
                    License license = new License(LicenseKeyActivationDialog.this.productInformation.getProductPublicKey(), LicenseKeyActivationDialog.this.keyField.getText());
                    if (license.isValid(LicenseKeyActivationDialog.this.productInformation.getProductName(), LicenseKeyActivationDialog.this.emailField.getText())) {
                        LicenseKeyActivationDialog.this.validityLabel.setText("License is valid. Press OK to activate. You need to reload the current process to apply changes.");
                        LicenseKeyActivationDialog.this.validityLabel.setForeground(Color.black);
                    } else if (LicenseKeyActivationDialog.this.isClipboardAccessible) {
                        LicenseKeyActivationDialog.this.validityLabel.setText("License invalid.");
                        LicenseKeyActivationDialog.this.validityLabel.setForeground(Color.red);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

