/*
 * Decompiled with CFR 0.152.
 */
package com.owc.io;

import com.owc.tools.CSVParser;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.SecureRandom;
import java.text.DateFormat;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.codec.Charsets;

public class AESEncryptedExampleSetCSVInputStream
extends InputStream {
    private ExampleSet exampleSet;
    private Attribute[] publicAttributes;
    private Attribute[] encryptedAttributes;
    private byte[] currentPublicLine;
    private byte[] currentEncryptedLine;
    private int currentLinePointer = 0;
    private Iterator<Example> exampleIterator;
    private DateFormat dateFormat = CSVParser.getDefaultFormat();
    private Key key;
    private SecureRandom secureRandom;
    private byte[] secureRandomSeed;

    public AESEncryptedExampleSetCSVInputStream(ExampleSet exampleSet, List<Attribute> publicAttributes, List<Attribute> encryptedAttributes, Key key, SecureRandom secureRandom) {
        this.exampleSet = exampleSet;
        this.exampleIterator = exampleSet.iterator();
        this.publicAttributes = publicAttributes.toArray(new Attribute[publicAttributes.size()]);
        this.encryptedAttributes = encryptedAttributes.toArray(new Attribute[encryptedAttributes.size()]);
        Attribute[] headerAttributes = new Attribute[publicAttributes.size() + 2];
        headerAttributes[0] = AttributeFactory.createAttribute((String)"InitializationVector", (int)7);
        headerAttributes[1] = AttributeFactory.createAttribute((String)"Payload", (int)7);
        int i = 2;
        for (Attribute attribute : publicAttributes) {
            headerAttributes[i++] = attribute;
        }
        this.currentPublicLine = CSVParser.formatHeader(headerAttributes, true, '\"', '\\', ",", this.dateFormat).getBytes(Charsets.UTF_8);
        this.currentEncryptedLine = null;
        this.key = key;
        this.secureRandomSeed = secureRandom.generateSeed(16);
        this.secureRandom = new SecureRandom(this.secureRandomSeed);
    }

    @Override
    public int read() throws IOException {
        if (this.currentEncryptedLine != null) {
            if (this.currentLinePointer < this.currentEncryptedLine.length) {
                return this.currentEncryptedLine[this.currentLinePointer++];
            }
            this.currentEncryptedLine = null;
            this.currentLinePointer = 0;
        }
        if (this.currentLinePointer < this.currentPublicLine.length) {
            return this.currentPublicLine[this.currentLinePointer++];
        }
        if (!this.exampleIterator.hasNext()) {
            return -1;
        }
        Example example = this.exampleIterator.next();
        this.currentEncryptedLine = this.getEncryptedLine(example);
        this.currentPublicLine = CSVParser.formatExample(example, this.publicAttributes, true, '\"', '\\', ",", this.dateFormat).getBytes(Charsets.UTF_8);
        this.currentLinePointer = 0;
        return this.currentEncryptedLine[this.currentLinePointer++];
    }

    /*
     * Exception decompiling
     */
    private byte[] getEncryptedLine(Example example) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public synchronized void reset() throws IOException {
        this.secureRandom = new SecureRandom(this.secureRandomSeed);
        this.currentEncryptedLine = null;
        this.currentLinePointer = 0;
        this.exampleIterator = this.exampleSet.iterator();
        Attribute[] headerAttributes = new Attribute[this.publicAttributes.length + 2];
        headerAttributes[0] = AttributeFactory.createAttribute((String)"InitializationVector", (int)7);
        headerAttributes[1] = AttributeFactory.createAttribute((String)"Payload", (int)7);
        int i = 2;
        for (Attribute attribute : this.publicAttributes) {
            headerAttributes[i++] = attribute;
        }
        this.currentPublicLine = CSVParser.formatHeader(headerAttributes, true, '\"', '\\', ",", this.dateFormat).getBytes(Charsets.UTF_8);
    }

    public static byte[] longToBytes(long longValue) {
        byte[] result = new byte[8];
        for (int i = 7; i >= 0; --i) {
            result[i] = (byte)(longValue & 0xFFL);
            longValue >>= 8;
        }
        return result;
    }

    public static byte[] intToBytes(int l) {
        byte[] result = new byte[4];
        for (int i = 3; i >= 0; --i) {
            result[i] = (byte)(l & 0xFF);
            l >>= 8;
        }
        return result;
    }
}

