/*
 * Decompiled with CFR 0.152.
 */
package com.owc.io;

import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;

public class SigningOutputStream
extends OutputStream {
    private static final int EOF = 4;
    private static final int ESCAPE = 0;
    private Signature signatureMethod;
    private OutputStream outputStream;

    public SigningOutputStream(OutputStream output, PrivateKey privateKey) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        this(output, "SHA256withRSA", privateKey);
    }

    public SigningOutputStream(OutputStream outputStream, String signingMethod, PrivateKey privateKey) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        this(outputStream, signingMethod, privateKey, null);
    }

    public SigningOutputStream(OutputStream outputStream, String signingMethod, PrivateKey privateKey, byte[] salt) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        this.signatureMethod = Signature.getInstance(signingMethod);
        this.signatureMethod.initSign(privateKey);
        if (salt != null) {
            this.signatureMethod.update(salt);
        }
        this.outputStream = outputStream;
    }

    @Override
    public void write(int b) throws IOException {
        try {
            this.signatureMethod.update((byte)b);
        }
        catch (SignatureException e) {
            throw new IOException("Signing exception.", e);
        }
        if (b == 4 || b == 0) {
            this.outputStream.write(0);
        }
        this.outputStream.write(b);
    }

    @Override
    public void close() throws IOException {
        try {
            byte[] signature = this.signatureMethod.sign();
            this.outputStream.write(4);
            this.outputStream.write(4);
            this.outputStream.write(signature);
            this.outputStream.flush();
        }
        catch (SignatureException e) {
            throw new IOException("Signing exception.", e);
        }
        super.close();
    }
}

