/*
 * Decompiled with CFR 0.152.
 */
package com.owc.json.actions;

import com.fasterxml.jackson.core.JsonParser;
import com.owc.json.actions.ParseAction;
import com.owc.json.actions.PathElement;
import com.owc.tools.ExampleSetCreator;
import com.rapidminer.tools.container.Pair;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;

public class ResetScopeParseAction
implements ParseAction {
    private static final long serialVersionUID = -5603613292370335617L;
    private Integer setID;
    private PathElement[] path;
    private ParseAction parent;

    public ResetScopeParseAction(PathElement[] path, ParseAction parent) {
        this.parent = parent;
        this.path = path;
    }

    @Override
    public void trigger(JsonParser jsonParser, Map<Integer, ExampleSetCreator> creators, Map<Pair<ParseAction, Integer>, Integer> rowAffectionScope) throws IOException {
        ExampleSetCreator exampleSetCreator = creators.get(this.setID);
        rowAffectionScope.put((Pair<ParseAction, Integer>)new Pair((Object)this.parent, (Object)this.setID), exampleSetCreator.size());
    }

    public String toString() {
        if (this.setID == null) {
            return "reset scope at " + PathElement.toString(this.path);
        }
        return "reset scope (" + this.setID + ") at " + PathElement.toString(this.path);
    }

    @Override
    public PathElement[] getPath() {
        return this.path;
    }

    @Override
    public void setSetID(int id) {
        this.setID = id;
        this.parent.setSetID(id);
    }

    @Override
    public int getSetID() {
        return this.setID;
    }

    @Override
    public ParseAction clone() {
        return new ResetScopeParseAction(Arrays.copyOf(this.path, this.path.length), this.parent.clone());
    }
}

