/*
 * Decompiled with CFR 0.152.
 */
package com.owc.json.actions;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.owc.json.actions.ParseAction;
import com.owc.json.actions.PathElement;
import com.owc.tools.ExampleSetCreator;
import com.rapidminer.operator.UserError;
import com.rapidminer.tools.container.Pair;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Map;

public class SetDateValueParseAction
implements ParseAction {
    private static final long serialVersionUID = -8128697656087355057L;
    private Integer setID;
    private String attributeName;
    private DateFormat format;
    private PathElement[] path;

    public SetDateValueParseAction(String attributeName, DateFormat format, PathElement[] path) {
        this.attributeName = attributeName;
        this.format = format;
        this.path = path;
    }

    @Override
    public void trigger(JsonParser jsonParser, Map<Integer, ExampleSetCreator> creators, Map<Pair<ParseAction, Integer>, Integer> rowAffectionScope) throws IOException, UserError {
        int rowsAffectedSince;
        long epochMilli;
        ExampleSetCreator exampleSetCreator = creators.get(this.setID);
        boolean isNull = jsonParser.getCurrentToken() == JsonToken.VALUE_NULL;
        try {
            epochMilli = this.format.parse(jsonParser.getText()).toInstant().toEpochMilli();
        }
        catch (ParseException e) {
            throw new UserError(null, (Throwable)e, "web_automation.wrong_date_format", new Object[]{this.attributeName, Arrays.toString(this.path), jsonParser.getText()});
        }
        if (!isNull) {
            creators.get(this.setID).setValue(this.attributeName, epochMilli);
        } else {
            exampleSetCreator.setMissing(this.attributeName);
        }
        for (int i = rowsAffectedSince = rowAffectionScope.get(new Pair((Object)this, (Object)this.setID)).intValue(); i < exampleSetCreator.size(); ++i) {
            exampleSetCreator.reopen(i);
            if (!isNull) {
                exampleSetCreator.setValue(this.attributeName, epochMilli);
            } else {
                exampleSetCreator.setMissing(this.attributeName);
            }
            exampleSetCreator.commit();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributeName == null ? 0 : this.attributeName.hashCode());
        result = 31 * result + (this.format == null ? 0 : this.format.hashCode());
        result = 31 * result + (this.setID == null ? 0 : this.setID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SetDateValueParseAction other = (SetDateValueParseAction)obj;
        if (this.attributeName == null ? other.attributeName != null : !this.attributeName.equals(other.attributeName)) {
            return false;
        }
        if (this.format == null ? other.format != null : !this.format.equals(other.format)) {
            return false;
        }
        return !(this.setID == null ? other.setID != null : !this.setID.equals(other.setID));
    }

    public String toString() {
        if (this.setID == null) {
            return "set date [" + this.attributeName + "] at " + PathElement.toString(this.path);
        }
        return "set date [" + this.attributeName + "] at " + PathElement.toString(this.path);
    }

    @Override
    public PathElement[] getPath() {
        return this.path;
    }

    @Override
    public int getSetID() {
        return this.setID;
    }

    @Override
    public void setSetID(int id) {
        this.setID = id;
    }

    @Override
    public ParseAction clone() {
        return new SetDateValueParseAction(this.attributeName, this.format, Arrays.copyOf(this.path, this.path.length));
    }
}

