/*
 * Decompiled with CFR 0.152.
 */
package com.owc.json.actions;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.owc.json.actions.ParseAction;
import com.owc.json.actions.PathElement;
import com.owc.tools.ExampleSetCreator;
import com.rapidminer.tools.container.Pair;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;

public class SetNominalValueParseAction
implements ParseAction {
    private static final long serialVersionUID = 4741993489349620840L;
    private Integer setID;
    private String attributeName;
    private PathElement[] path;

    public SetNominalValueParseAction(String attributeName, PathElement[] path) {
        this.attributeName = attributeName;
        this.path = path;
    }

    @Override
    public void trigger(JsonParser jsonParser, Map<Integer, ExampleSetCreator> creators, Map<Pair<ParseAction, Integer>, Integer> rowAffectionScope) throws IOException {
        int rowsAffectedSince;
        boolean isNull;
        ExampleSetCreator exampleSetCreator = creators.get(this.setID);
        boolean bl = isNull = jsonParser.getCurrentToken() == JsonToken.VALUE_NULL;
        if (!isNull) {
            exampleSetCreator.setValue(this.attributeName, jsonParser.getText());
        } else {
            exampleSetCreator.setMissing(this.attributeName);
        }
        for (int i = rowsAffectedSince = rowAffectionScope.get(new Pair((Object)this, (Object)this.setID)).intValue(); i < exampleSetCreator.size(); ++i) {
            exampleSetCreator.reopen(i);
            if (!isNull) {
                exampleSetCreator.setValue(this.attributeName, jsonParser.getText());
            } else {
                exampleSetCreator.setMissing(this.attributeName);
            }
            exampleSetCreator.commit();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributeName == null ? 0 : this.attributeName.hashCode());
        result = 31 * result + (this.setID == null ? 0 : this.setID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SetNominalValueParseAction other = (SetNominalValueParseAction)obj;
        if (this.attributeName == null ? other.attributeName != null : !this.attributeName.equals(other.attributeName)) {
            return false;
        }
        return !(this.setID == null ? other.setID != null : !this.setID.equals(other.setID));
    }

    public String toString() {
        if (this.setID == null) {
            return "set nominal [" + this.attributeName + "] at " + PathElement.toString(this.path);
        }
        return "set nominal [" + this.attributeName + "] at " + PathElement.toString(this.path);
    }

    @Override
    public PathElement[] getPath() {
        return this.path;
    }

    @Override
    public void setSetID(int id) {
        this.setID = id;
    }

    @Override
    public int getSetID() {
        return this.setID;
    }

    @Override
    public ParseAction clone() {
        return new SetNominalValueParseAction(this.attributeName, Arrays.copyOf(this.path, this.path.length));
    }
}

