/*
 * Decompiled with CFR 0.152.
 */
package com.owc.math.aggregation;

import com.owc.math.aggregation.NumericalStreamableAggregator;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import java.util.TreeMap;

public class MinAggregator
implements NumericalStreamableAggregator {
    private Attribute attribute;
    private TreeMap<Double, Counter> values = new TreeMap();

    public MinAggregator(Attribute attribute) {
        this.attribute = attribute;
    }

    @Override
    public final double get() {
        if (!this.values.isEmpty()) {
            return this.values.firstKey();
        }
        return Double.NaN;
    }

    @Override
    public final void count(Example example) {
        double value = example.getValue(this.attribute);
        Counter counter = this.values.get(value);
        if (counter == null) {
            this.values.put(value, new Counter());
        } else {
            ++counter.count;
        }
    }

    @Override
    public final void count(Example example, double weight) {
        double value = example.getValue(this.attribute);
        Counter counter = this.values.get(value);
        if (counter == null) {
            this.values.put(value, new Counter());
        } else {
            ++counter.count;
        }
    }

    @Override
    public final void disregard(Example example) {
        double value = example.getValue(this.attribute);
        Counter counter = this.values.get(value);
        --counter.count;
        if (counter.count == 0) {
            this.values.remove(value);
        }
    }

    @Override
    public final void disregard(Example example, double weight) {
        double value = example.getValue(this.attribute);
        Counter counter = this.values.get(value);
        --counter.count;
        if (counter.count == 0) {
            this.values.remove(value);
        }
    }

    private class Counter {
        int count = 1;

        private Counter() {
        }
    }
}

