/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.owc.license.ProductInformation;
import com.owc.metadata.JSONParserSpecificationMetaData;
import com.owc.objects.JSONParserSpecificationObject;
import com.owc.operator.LicensedOperator;
import com.owc.process.ports.NamedOneToOneExtender;
import com.owc.process.ports.NamedPortPairExtender;
import com.owc.tools.ExampleSetCreator;
import com.owc.tools.JSONTools;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.PluginInitWebAutomationExtension;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeBoolean;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ParseJSONDataOperator
extends LicensedOperator {
    private static final String PARAMETER_ATTRIBUTE = "attribute";
    private static final String PARAMETER_KEEP_EXAMPLE_SET = "keep_example_set";
    private static JsonFactory JSON_FACTORY = new JsonFactory();
    private InputPort exampleSetInputPort = this.getInputPorts().createPort("example set", ExampleSet.class);
    private NamedOneToOneExtender parseSpecificationExtender = new NamedOneToOneExtender("parse specifications", "example set", this.getInputPorts(), this.getOutputPorts());

    public ParseJSONDataOperator(OperatorDescription description) {
        super(description);
        this.parseSpecificationExtender.start();
        this.getTransformer().addRule(new MDTransformationRule(){

            public void transformMD() {
                for (NamedPortPairExtender.NamedPortPair pair : ParseJSONDataOperator.this.parseSpecificationExtender.getManagedPairs()) {
                    if (!pair.getInputPort().isConnected()) continue;
                    MetaData metaData = pair.getInputPort().getMetaData();
                    if (metaData != null && metaData instanceof JSONParserSpecificationMetaData) {
                        JSONParserSpecificationMetaData specMd = (JSONParserSpecificationMetaData)metaData.clone();
                        pair.getOutputPort().deliverMD((MetaData)specMd.getExampleSetDefinition());
                        continue;
                    }
                    pair.getOutputPort().deliverMD((MetaData)new ExampleSetMetaData());
                }
            }
        });
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        if (!isLicensed) {
            throw new UserError((Operator)this, "toolkit.license_exceeded_functionality");
        }
        ExampleSet dataSet = (ExampleSet)this.exampleSetInputPort.getData(ExampleSet.class);
        List<JSONParserSpecificationObject> parserSpecifications = this.parseSpecificationExtender.getData(JSONParserSpecificationObject.class);
        String attributeName = this.getParameterAsString(PARAMETER_ATTRIBUTE);
        boolean keepExampleSet = this.getParameterAsBoolean(PARAMETER_KEEP_EXAMPLE_SET);
        Attribute jsonAttribute = dataSet.getAttributes().get(attributeName);
        if (jsonAttribute == null) {
            throw new UserError((Operator)this, "web_automation.json.attribute_missing", new Object[]{attributeName});
        }
        if (!jsonAttribute.isNominal()) {
            throw new UserError((Operator)this, "web_automation.json.source_attribute_must_be_nominal", new Object[]{attributeName});
        }
        LinkedHashMap<Integer, ExampleSetCreator> creators = JSONTools.createCreators(parserSpecifications);
        ExampleSetCreator firstCreator = null;
        if (keepExampleSet && !creators.isEmpty()) {
            int allSize = dataSet.getAttributes().allSize() - 1;
            String[] additionalNames = new String[allSize];
            int[] additionalTypes = new int[allSize];
            Iterator additionalAttributes = dataSet.getAttributes().allAttributes();
            int i = 0;
            while (additionalAttributes.hasNext()) {
                Attribute additionalAttribute = (Attribute)additionalAttributes.next();
                if (additionalAttribute == jsonAttribute) continue;
                additionalNames[i] = additionalAttribute.getName();
                additionalTypes[i] = additionalAttribute.getValueType();
                ++i;
            }
            Map.Entry<Integer, ExampleSetCreator> firstEntry = creators.entrySet().iterator().next();
            Integer key = firstEntry.getKey();
            firstCreator = firstEntry.getValue().getExtendedInstance(additionalNames, additionalTypes);
            creators.replace(key, firstCreator);
        }
        LinkedHashMap<Integer, ExampleSet> sets = null;
        for (Example dataExample : dataSet) {
            if (firstCreator != null) {
                Iterator attributesIterator = dataExample.getAttributes().allAttributes();
                while (attributesIterator.hasNext()) {
                    Attribute copyAttribute = (Attribute)attributesIterator.next();
                    if (copyAttribute == jsonAttribute) continue;
                    double exampleValue = dataExample.getValue(copyAttribute);
                    if (Double.isNaN(exampleValue)) {
                        firstCreator.setValue(copyAttribute.getName(), Double.NaN);
                        continue;
                    }
                    if (copyAttribute.isNominal()) {
                        firstCreator.setValue(copyAttribute.getName(), dataExample.getValueAsString(copyAttribute));
                        continue;
                    }
                    firstCreator.setValue(copyAttribute.getName(), exampleValue);
                }
            }
            String jsonString = dataExample.getNominalValue(jsonAttribute);
            try {
                JsonParser jsonParser = JSON_FACTORY.createParser(jsonString);
                Throwable throwable = null;
                try {
                    sets = JSONTools.parseJSON(parserSpecifications, jsonParser, creators);
                    for (Map.Entry<Integer, ExampleSetCreator> entry : creators.entrySet()) {
                        entry.getValue().resetRow();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (jsonParser == null) continue;
                    if (throwable != null) {
                        try {
                            jsonParser.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    jsonParser.close();
                }
            }
            catch (JsonParseException e) {
                throw new OperatorException("web_automation.illegal_json", null, new Object[0]);
            }
            catch (IOException e) {
                throw new OperatorException("web_automation.io_error", null, new Object[0]);
            }
            catch (UserError e) {
                e.setOperator((Operator)this);
                throw e;
            }
        }
        if (sets != null) {
            this.parseSpecificationExtender.deliver(new LinkedList(sets.values()));
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeAttribute type = new ParameterTypeAttribute(PARAMETER_ATTRIBUTE, "The attribute containing the JSON fragments that shall be imported.", this.exampleSetInputPort, false, new int[]{1});
        type.setExpert(false);
        types.add((ParameterType)type);
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_KEEP_EXAMPLE_SET, "If checked the first delivered example set will contain the original, data set, with the exception of the JSON attribute..", true, false));
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitWebAutomationExtension.PRODUCT_INFORMATION;
    }
}

