/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.owc.json.Parser;
import com.owc.license.ProductInformation;
import com.owc.metadata.JSONParserSpecificationMetaData;
import com.owc.objects.JSONParserSpecificationObject;
import com.owc.operator.LicensedOperator;
import com.owc.process.ports.NamedOneToOneExtender;
import com.owc.process.ports.NamedPortPairExtender;
import com.owc.tools.JSONTools;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.PluginInitWebAutomationExtension;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeText;
import com.rapidminer.parameter.TextType;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

public class ParseJSONOperator
extends LicensedOperator {
    private static final String PARAMETER_JSON = "json";
    private static JsonFactory JSON_FACTORY = new JsonFactory();
    private NamedOneToOneExtender parseSpecificationExtender = new NamedOneToOneExtender("parse specifications", "example set", this.getInputPorts(), this.getOutputPorts());

    public ParseJSONOperator(OperatorDescription description) {
        super(description);
        this.parseSpecificationExtender.start();
        this.getTransformer().addRule(new MDTransformationRule(){

            public void transformMD() {
                for (NamedPortPairExtender.NamedPortPair pair : ParseJSONOperator.this.parseSpecificationExtender.getManagedPairs()) {
                    if (!pair.getInputPort().isConnected()) continue;
                    MetaData metaData = pair.getInputPort().getMetaData();
                    if (metaData != null && metaData instanceof JSONParserSpecificationMetaData) {
                        JSONParserSpecificationMetaData specMd = (JSONParserSpecificationMetaData)metaData.clone();
                        pair.getOutputPort().deliverMD((MetaData)specMd.getExampleSetDefinition());
                        continue;
                    }
                    pair.getOutputPort().deliverMD((MetaData)new ExampleSetMetaData());
                }
            }
        });
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        if (!isLicensed) {
            throw new UserError((Operator)this, "toolkit.license_exceeded_functionality");
        }
        List<JSONParserSpecificationObject> parserSpecifications = this.parseSpecificationExtender.getData(JSONParserSpecificationObject.class);
        String json = this.getParameterAsString(PARAMETER_JSON);
        try (JsonParser jsonParser = JSON_FACTORY.createParser(json);){
            Parser parser = new Parser();
            LinkedHashMap<Integer, ExampleSet> sets = JSONTools.parseJSON(parserSpecifications, jsonParser);
            this.parseSpecificationExtender.deliver(new LinkedList<ExampleSet>(sets.values()));
        }
        catch (JsonParseException e) {
            throw new OperatorException("web_automation.illegal_json", (Throwable)e, new Object[0]);
        }
        catch (IOException e) {
            throw new OperatorException("web_automation.io_error", (Throwable)e, new Object[0]);
        }
        catch (UserError e) {
            e.setOperator((Operator)this);
            throw e;
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeText type = new ParameterTypeText(PARAMETER_JSON, "The json code to read in.", TextType.GROOVY);
        type.setExpert(false);
        types.add((ParameterType)type);
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitWebAutomationExtension.PRODUCT_INFORMATION;
    }
}

