/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.json.specifications;

import com.owc.json.actions.ParseAction;
import com.owc.json.actions.PathElement;
import com.owc.json.actions.ResetScopeParseAction;
import com.owc.json.actions.SetDateValueParseAction;
import com.owc.json.actions.SetNominalValueParseAction;
import com.owc.json.actions.SetNumericValueParseAction;
import com.owc.license.ProductInformation;
import com.owc.metadata.JSONParserSpecificationMetaData;
import com.owc.objects.JSONParserSpecificationObject;
import com.owc.operator.LicensedOperator;
import com.owc.process.ports.OneToOneExtender;
import com.owc.tools.ExampleSetCreatorBuilder;
import com.rapidminer.extension.PluginInitWebAutomationExtension;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.MetaDataError;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDateFormat;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.Tools;
import java.text.SimpleDateFormat;
import java.util.List;

public class ExtractJSONValueOperator
extends LicensedOperator {
    public static final String PARAMETER_ATTRIBUTE_TYPE = "attribute_type";
    public static final String PARAMETER_ATTRIBUTE_NAME = "attribute_name";
    public static final String PARAMETER_DATE_FORMAT = "date_format";
    public static final String PARAMETER_TIME_ZONE = "time_zone";
    private OneToOneExtender parseSpecificationExtender = new OneToOneExtender("parse specifications", this.getInputPorts(), this.getOutputPorts());

    public ExtractJSONValueOperator(OperatorDescription description) {
        super(description);
        this.parseSpecificationExtender.start();
        this.getTransformer().addRule(new MDTransformationRule(){

            public void transformMD() {
                for (OneToOneExtender.PortPair pair : ExtractJSONValueOperator.this.parseSpecificationExtender.getManagedPairs()) {
                    if (!pair.getInputPort().isConnected()) continue;
                    MetaData metaData = pair.getInputPort().getMetaData();
                    if (metaData instanceof JSONParserSpecificationMetaData) {
                        JSONParserSpecificationMetaData specMD = (JSONParserSpecificationMetaData)metaData.clone();
                        try {
                            String attributeName = ExtractJSONValueOperator.this.getParameterAsString(ExtractJSONValueOperator.PARAMETER_ATTRIBUTE_NAME);
                            int attributeValueType = Ontology.ATTRIBUTE_VALUE_TYPE.mapName(ExtractJSONValueOperator.this.getParameterAsString(ExtractJSONValueOperator.PARAMETER_ATTRIBUTE_TYPE));
                            specMD.addAttribute(attributeName, attributeValueType);
                        }
                        catch (UndefinedParameterError undefinedParameterError) {
                            // empty catch block
                        }
                        pair.getOutputPort().deliverMD((MetaData)specMD);
                        continue;
                    }
                    pair.getInputPort().addError((MetaDataError)new SimpleMetaDataError(ProcessSetupError.Severity.WARNING, (Port)pair.getInputPort(), "wrong_type", new Object[0]));
                }
            }
        });
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        SimpleDateFormat dateFormat;
        List<JSONParserSpecificationObject> parserObjects = this.parseSpecificationExtender.getDataOrNull(JSONParserSpecificationObject.class);
        try {
            dateFormat = new SimpleDateFormat(this.getParameterAsString(PARAMETER_DATE_FORMAT));
        }
        catch (IllegalArgumentException e) {
            throw new UserError((Operator)this, "invalid_date_format", new Object[]{e, this.getParameterAsString(PARAMETER_DATE_FORMAT), e.getMessage()});
        }
        int timeZone = this.getParameterAsInt(PARAMETER_TIME_ZONE);
        if (timeZone < 0 || timeZone >= Tools.getAllTimeZones().length) {
            throw new UserError((Operator)this, 205, new Object[]{PARAMETER_TIME_ZONE});
        }
        dateFormat.setTimeZone(Tools.getTimeZone((int)timeZone));
        for (JSONParserSpecificationObject parserObject : parserObjects) {
            if (parserObject == null) continue;
            PathElement[] path = parserObject.getCurrentPath();
            ExampleSetCreatorBuilder setBuilder = parserObject.getExampleSetCreatorBuilder();
            String attributeName = this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME);
            int attributeValueType = Ontology.ATTRIBUTE_VALUE_TYPE.mapName(this.getParameterAsString(PARAMETER_ATTRIBUTE_TYPE));
            setBuilder.addAttribute(attributeName, attributeValueType);
            ParseAction setValueAction = null;
            if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attributeValueType, 1)) {
                setValueAction = new SetNominalValueParseAction(attributeName, path);
            } else if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attributeValueType, 3)) {
                setValueAction = new SetNumericValueParseAction(attributeName, path);
            } else if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attributeValueType, 2)) {
                setValueAction = new SetNumericValueParseAction(attributeName, path);
            } else if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attributeValueType, 9)) {
                setValueAction = new SetDateValueParseAction(attributeName, dateFormat, path);
            }
            parserObject.addAction(setValueAction);
            PathElement[] currentPath = parserObject.getCurrentPath();
            for (int i = 0; i < currentPath.length; ++i) {
                PathElement[] hookPath = new PathElement[i + 1];
                System.arraycopy(currentPath, 0, hookPath, 0, i + 1);
                parserObject.addLeaveAction(new ResetScopeParseAction(hookPath, setValueAction));
            }
        }
        this.parseSpecificationExtender.passDataThrough();
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add((ParameterType)new ParameterTypeString(PARAMETER_ATTRIBUTE_NAME, "The name of the attribute", false, false));
        types.add((ParameterType)new ParameterTypeCategory(PARAMETER_ATTRIBUTE_TYPE, "The attribute value type", Ontology.VALUE_TYPE_NAMES, 7, false));
        types.add((ParameterType)new ParameterTypeDateFormat(PARAMETER_DATE_FORMAT, "The date format used for filling the macros.", "yyyy-MM-dd HH:mm:ss", false));
        types.add((ParameterType)new ParameterTypeCategory(PARAMETER_TIME_ZONE, "The time zone used for the date objects if not specified in the date string itself.", Tools.getAllTimeZones(), Tools.getPreferredTimeZoneIndex()));
        for (ParameterType typeI : types) {
            typeI.setExpert(false);
        }
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitWebAutomationExtension.PRODUCT_INFORMATION;
    }
}

