/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.json.specifications;

import com.owc.json.actions.CreateIDParseAction;
import com.owc.json.actions.PathElement;
import com.owc.json.actions.ResetRowParseAction;
import com.owc.json.actions.ResetScopeParseAction;
import com.owc.json.actions.SetNominalConstantParseAction;
import com.owc.license.ProductInformation;
import com.owc.metadata.JSONParserSpecificationMetaData;
import com.owc.objects.JSONParserSpecificationObject;
import com.owc.operator.OrderedPortOperatorChain;
import com.owc.process.ports.OneToOneExtender;
import com.owc.process.ports.metadata.SubprocessesTransformationRule;
import com.owc.tools.ExampleSetCreatorBuilder;
import com.rapidminer.extension.PluginInitWebAutomationExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.operator.ports.metadata.SimplePrecondition;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.parameter.conditions.PortConnectedCondition;
import java.util.Collections;
import java.util.List;

public class ProcessJSONArrayOperator
extends OrderedPortOperatorChain {
    public static final String PARAMETER_PROPERTY_NAME = "property_name";
    public static final String PARAMETER_ARRAY_TYPE = "array_type";
    public static final String PARAMETER_CREATE_ID = "create_id_attribute";
    public static final String PARAMETER_ID_ATTRIBUTE_NAME = "id_attribute_name";
    public static final String PARAMETER_ATTRIBUTE_NAME = "attribute_name";
    private static final int ARRAY_TYPE_SCALAR_ARRAY = 0;
    private static final int ARRAY_TYPE_OBJECT_ARRAY = 1;
    private static final int ARRAY_TYPE_NESTED_ARRAY = 2;
    private OneToOneExtender inputExtender = new OneToOneExtender("input", this.getInputPorts(), this.getSubprocess(0).getInnerSources()).startAndReturn();
    private InputPort parserObjectInput = (InputPort)this.getInputPorts().createPort("parse specification");
    private OutputPort innerParserObjectSource = (OutputPort)this.getSubprocess(0).getInnerSources().createPort("parse specification");
    private OneToOneExtender parseSpecificationExtender = new OneToOneExtender("parse specifications", this.getSubprocess(0).getInnerSinks(), this.getOutputPorts());

    public ProcessJSONArrayOperator(OperatorDescription description) {
        super(description, "Process Object");
        this.parseSpecificationExtender.start();
        this.parserObjectInput.addPrecondition((Precondition)new SimplePrecondition(this.parserObjectInput, (MetaData)new JSONParserSpecificationMetaData(), false));
        this.getTransformer().addRule(new MDTransformationRule(){

            public void transformMD() {
                MetaData metaData = ProcessJSONArrayOperator.this.parserObjectInput.getMetaData();
                if (metaData == null) {
                    metaData = new JSONParserSpecificationMetaData();
                }
                ProcessJSONArrayOperator.this.innerParserObjectSource.deliverMD(metaData);
            }
        });
        this.getTransformer().addRule(this.inputExtender.makePassThroughRule());
        this.getTransformer().addRule((MDTransformationRule)new SubprocessesTransformationRule(this));
        this.getTransformer().addRule(this.parseSpecificationExtender.makePassThroughRule());
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        String attributeName;
        JSONParserSpecificationObject inputSpecification = (JSONParserSpecificationObject)this.parserObjectInput.getDataOrNull(JSONParserSpecificationObject.class);
        boolean isPropertyOfObject = false;
        if (inputSpecification == null) {
            inputSpecification = new JSONParserSpecificationObject();
        } else if (this.isParameterSet(PARAMETER_PROPERTY_NAME) && !this.getParameterAsString(PARAMETER_PROPERTY_NAME).trim().isEmpty()) {
            inputSpecification.pushContextPathElement(new PathElement(this.getParameterAsString(PARAMETER_PROPERTY_NAME)));
            isPropertyOfObject = true;
        }
        boolean isScalar = false;
        switch (this.getParameterAsInt(PARAMETER_ARRAY_TYPE)) {
            case 1: {
                inputSpecification.pushContextPathElement(PathElement.ARRAY_ELEMENT);
                inputSpecification.pushContextPathElement(PathElement.OBJECT_ELEMENT);
                break;
            }
            case 0: {
                inputSpecification.pushContextPathElement(PathElement.ARRAY_ELEMENT);
                inputSpecification.pushContextPathElement(PathElement.VALUE_ELEMENT);
                isScalar = true;
                break;
            }
            default: {
                inputSpecification.pushContextPathElement(PathElement.ARRAY_ELEMENT);
            }
        }
        if (this.getParameterAsBoolean(PARAMETER_CREATE_ID)) {
            inputSpecification.getExampleSetCreatorBuilder().addAttribute(this.getParameterAsString(PARAMETER_ID_ATTRIBUTE_NAME), 3);
            CreateIDParseAction idAction = new CreateIDParseAction(this.getParameterAsString(PARAMETER_ID_ATTRIBUTE_NAME), inputSpecification.getCurrentPath());
            inputSpecification.addAction(idAction);
            PathElement[] currentPath = inputSpecification.getCurrentPath();
            for (int i = 0; i < currentPath.length; ++i) {
                PathElement[] hookPath = new PathElement[i + 1];
                System.arraycopy(currentPath, 0, hookPath, 0, i + 1);
                inputSpecification.addLeaveAction(new ResetScopeParseAction(hookPath, idAction));
            }
        }
        if ((attributeName = this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME)) != null && !attributeName.isEmpty()) {
            inputSpecification.getExampleSetCreatorBuilder().addAttribute(attributeName, 7);
            SetNominalConstantParseAction setValueAction = new SetNominalConstantParseAction(attributeName, inputSpecification.getCurrentPath(), this.getParameterAsString(PARAMETER_PROPERTY_NAME));
            inputSpecification.addAction(setValueAction);
            PathElement[] currentPath = inputSpecification.getCurrentPath();
            for (int i = 0; i < currentPath.length - 1; ++i) {
                PathElement[] hookPath = new PathElement[i + 1];
                System.arraycopy(currentPath, 0, hookPath, 0, i + 1);
                inputSpecification.addLeaveAction(new ResetScopeParseAction(hookPath, setValueAction));
            }
        }
        ExampleSetCreatorBuilder originalBuilder = inputSpecification.getExampleSetCreatorBuilder().clone();
        this.inputExtender.passDataThrough();
        this.innerParserObjectSource.deliver((IOObject)inputSpecification);
        this.getSubprocess(0).execute();
        List<JSONParserSpecificationObject> specifications = this.parseSpecificationExtender.getDataOrNull(JSONParserSpecificationObject.class);
        for (JSONParserSpecificationObject specification : specifications) {
            if (specification == null) continue;
            List<String> addedAttributes = ExampleSetCreatorBuilder.computeDifference(originalBuilder, specification.getExampleSetCreatorBuilder());
            if (!isScalar && !addedAttributes.isEmpty()) {
                specification.addAction(new ResetRowParseAction(specification.getCurrentPath(), addedAttributes));
            }
            switch (this.getParameterAsInt(PARAMETER_ARRAY_TYPE)) {
                case 1: {
                    specification.popContextPathElement();
                    specification.popContextPathElement();
                    break;
                }
                case 0: {
                    specification.popContextPathElement();
                    specification.popContextPathElement();
                    break;
                }
                case 2: {
                    specification.popContextPathElement();
                }
            }
            if (isPropertyOfObject) {
                specification.popContextPathElement();
            }
            if (attributeName == null || attributeName.isEmpty()) continue;
            specification.addAction(new ResetRowParseAction(specification.getCurrentPath(), Collections.singletonList(attributeName)));
        }
        this.parseSpecificationExtender.deliver(specifications);
        this.parseSpecificationExtender.passDataThrough();
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeString type = new ParameterTypeString(PARAMETER_PROPERTY_NAME, "The property name of the object that shall be processed.", true);
        type.registerDependencyCondition((ParameterCondition)new PortConnectedCondition((ParameterHandler)this, () -> this.parserObjectInput, false, true));
        type.setExpert(false);
        types.add((ParameterType)type);
        types.add((ParameterType)new ParameterTypeCategory(PARAMETER_ARRAY_TYPE, "Select whether the array contains scalar values, complex objects or if it is an array of arrays.", new String[]{"scalar values", "objects", "arrays"}, 1, false));
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_CREATE_ID, "If checked an id will be created for every entry of this array. Can be useful if the order and indices inside the array matter.", false));
        type = new ParameterTypeString(PARAMETER_ID_ATTRIBUTE_NAME, "The name of the created id attribute", true);
        types.add((ParameterType)type);
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_CREATE_ID, true, true));
        type = new ParameterTypeString(PARAMETER_ATTRIBUTE_NAME, "If filled, the name of this property will be placed into the attribute. That can be used if data of different properties can be stored into one table to differenciate where they are taken from.", true);
        type.setExpert(false);
        type.registerDependencyCondition((ParameterCondition)new PortConnectedCondition((ParameterHandler)this, () -> this.parserObjectInput, false, true));
        types.add((ParameterType)type);
        for (ParameterType typeI : types) {
            typeI.setExpert(false);
        }
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitWebAutomationExtension.PRODUCT_INFORMATION;
    }
}

