/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.json.specifications;

import com.owc.json.actions.PathElement;
import com.owc.json.actions.ResetRowParseAction;
import com.owc.json.actions.ResetScopeParseAction;
import com.owc.json.actions.SetNominalConstantParseAction;
import com.owc.license.ProductInformation;
import com.owc.metadata.JSONParserSpecificationMetaData;
import com.owc.objects.JSONParserSpecificationObject;
import com.owc.operator.OrderedPortOperatorChain;
import com.owc.process.ports.OneToOneExtender;
import com.owc.process.ports.metadata.SubprocessesTransformationRule;
import com.owc.tools.ExampleSetCreatorBuilder;
import com.rapidminer.extension.PluginInitWebAutomationExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.operator.ports.metadata.SimplePrecondition;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.parameter.conditions.PortConnectedCondition;
import java.util.Collections;
import java.util.List;

public class ProcessJSONObjectOperator
extends OrderedPortOperatorChain {
    public static final String PARAMETER_PROPERTY_NAME = "property_name";
    public static final String PARAMETER_ATTRIBUTE_NAME = "attribute_name";
    private OneToOneExtender inputExtender = new OneToOneExtender("input", this.getInputPorts(), this.getSubprocess(0).getInnerSources()).startAndReturn();
    private InputPort parserObjectInput = (InputPort)this.getInputPorts().createPort("parse specification");
    private OutputPort innerParserObjectSource = (OutputPort)this.getSubprocess(0).getInnerSources().createPort("parse specification");
    private OneToOneExtender parseSpecificationExtender = new OneToOneExtender("parse specifications", this.getSubprocess(0).getInnerSinks(), this.getOutputPorts());

    public ProcessJSONObjectOperator(OperatorDescription description) {
        super(description, "Process Object");
        this.parseSpecificationExtender.start();
        this.parserObjectInput.addPrecondition((Precondition)new SimplePrecondition(this.parserObjectInput, (MetaData)new JSONParserSpecificationMetaData(), false));
        this.getTransformer().addRule(new MDTransformationRule(){

            public void transformMD() {
                MetaData metaData = ProcessJSONObjectOperator.this.parserObjectInput.getMetaData();
                if (metaData == null) {
                    metaData = new JSONParserSpecificationMetaData();
                }
                ProcessJSONObjectOperator.this.innerParserObjectSource.deliverMD(metaData);
            }
        });
        this.getTransformer().addRule(this.inputExtender.makePassThroughRule());
        this.getTransformer().addRule((MDTransformationRule)new SubprocessesTransformationRule(this));
        this.getTransformer().addRule(this.parseSpecificationExtender.makePassThroughRule());
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        JSONParserSpecificationObject parserObject = (JSONParserSpecificationObject)this.parserObjectInput.getDataOrNull(JSONParserSpecificationObject.class);
        boolean initial = false;
        if (parserObject == null) {
            parserObject = new JSONParserSpecificationObject();
            initial = true;
        } else {
            parserObject.pushContextPathElement(new PathElement(this.getParameterAsString(PARAMETER_PROPERTY_NAME)));
        }
        parserObject.pushContextPathElement(PathElement.OBJECT_ELEMENT);
        String attributeName = this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME);
        if (attributeName != null && !attributeName.isEmpty()) {
            parserObject.getExampleSetCreatorBuilder().addAttribute(attributeName, 7);
            SetNominalConstantParseAction setValueAction = new SetNominalConstantParseAction(attributeName, parserObject.getCurrentPath(), this.getParameterAsString(PARAMETER_PROPERTY_NAME));
            parserObject.addAction(setValueAction);
            PathElement[] currentPath = parserObject.getCurrentPath();
            for (int i = 0; i < currentPath.length - 1; ++i) {
                PathElement[] hookPath = new PathElement[i + 1];
                System.arraycopy(currentPath, 0, hookPath, 0, i + 1);
                parserObject.addLeaveAction(new ResetScopeParseAction(hookPath, setValueAction));
            }
        }
        ExampleSetCreatorBuilder originalBuilder = parserObject.getExampleSetCreatorBuilder().clone();
        this.inputExtender.passDataThrough();
        this.innerParserObjectSource.deliver((IOObject)parserObject);
        this.getSubprocess(0).execute();
        List<JSONParserSpecificationObject> specifications = this.parseSpecificationExtender.getDataOrNull(JSONParserSpecificationObject.class);
        for (JSONParserSpecificationObject specification : specifications) {
            List<String> addedAttributes;
            if (specification == null) continue;
            if (!initial && !(addedAttributes = ExampleSetCreatorBuilder.computeDifference(originalBuilder, specification.getExampleSetCreatorBuilder())).isEmpty()) {
                specification.addAction(new ResetRowParseAction(specification.getCurrentPath(), addedAttributes));
            }
            specification.popContextPathElement();
            if (!initial) {
                specification.popContextPathElement();
            }
            if (attributeName == null || attributeName.isEmpty()) continue;
            specification.addAction(new ResetRowParseAction(specification.getCurrentPath(), Collections.singletonList(attributeName)));
        }
        this.parseSpecificationExtender.deliver(specifications);
        this.parseSpecificationExtender.passDataThrough();
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeString type = new ParameterTypeString(PARAMETER_PROPERTY_NAME, "The property name of the object that shall be processed.", true);
        type.registerDependencyCondition((ParameterCondition)new PortConnectedCondition((ParameterHandler)this, () -> this.parserObjectInput, true, true));
        type.setExpert(false);
        types.add((ParameterType)type);
        type = new ParameterTypeString(PARAMETER_ATTRIBUTE_NAME, "If filled, the name of this property will be placed into the attribute. That can be used if data of different properties can be stored into one table to differenciate where they are taken from.", true);
        type.setExpert(false);
        type.registerDependencyCondition((ParameterCondition)new PortConnectedCondition((ParameterHandler)this, () -> this.parserObjectInput, false, true));
        types.add((ParameterType)type);
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitWebAutomationExtension.PRODUCT_INFORMATION;
    }
}

