/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.rest;

import com.owc.io.http.HttpConnectionManager;
import com.owc.io.http.SimpleCookieJar;
import com.owc.license.ProductInformation;
import com.owc.operator.OrderedPortOperator;
import com.owc.process.ports.OneToOneExtender;
import com.owc.process.ports.metadata.GenerateFixedExampleSetMDRule;
import com.owc.rest.RestConnectionConfigurable;
import com.owc.tools.ExampleSetCreator;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.PluginInitWebAutomationExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.operator.ports.metadata.SimplePrecondition;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import com.rapidminer.parameter.ParameterTypeText;
import com.rapidminer.parameter.TextType;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.EqualStringCondition;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.parameter.conditions.NonEqualStringCondition;
import com.rapidminer.parameter.conditions.OrParameterCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.tools.config.ConfigurationException;
import com.rapidminer.tools.config.ConfigurationManager;
import com.rapidminer.tools.config.ParameterTypeConfigurable;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.Map;
import okhttp3.Cookie;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.http.HttpMethod;

public abstract class AbstractSendRequestOperator
extends OrderedPortOperator {
    public static final String[] MIME_TYPES = new String[]{"application/x-www-form-urlencoded"};
    public static final String ATTRIBUTE_VALUE = "Value";
    public static final String ATTRIBUTE_HEADER = "Name";
    public static final String ATTRIBUTE_COOKIE = "Cookie";
    public static final String ATTRIBUTE_URL = "URL";
    public static final String PARAMETER_METHOD = "method";
    public static final String PARAMETER_BODY = "body";
    public static final String PARAMETER_ENABLE_COMPRESSION = "enable_compression";
    public static final String PARAMETER_BODY_CONTENT_TYPE = "body_content_type";
    public static final String PARAMETER_CONNECTION = "connection";
    public static final String PARAMETER_ENDPOINT = "endpoint";
    public static final String PARAMETER_HEADERS = "headers";
    public static final String PARAMETER_USE_FORM_EDITOR = "use_form_editor";
    public static final String PARAMETER_FORM_EDITOR = "form_editor";
    protected OneToOneExtender throughPort = new OneToOneExtender("through", this.getInputPorts(), this.getOutputPorts()).startAndReturn();
    protected InputPort cookieSetInputPort = (InputPort)this.getInputPorts().createPort("cookie set");
    protected OutputPort cookieSetOutputPort = (OutputPort)this.getOutputPorts().createPort("cookie set");
    protected InputPort headerSetInputPort = (InputPort)this.getInputPorts().createPort("header set");
    protected OutputPort headerSetOutputPort = (OutputPort)this.getOutputPorts().createPort("header set");
    protected static final ExampleSetCreator HEADER_SET_CREATOR = new ExampleSetCreator(new String[]{"Name", "Value"}, new int[]{7, 7});
    protected static final ExampleSetCreator COOKIE_SET_CREATOR = new ExampleSetCreator(new String[]{"URL", "Cookie"}, new int[]{7, 7});

    public AbstractSendRequestOperator(OperatorDescription description) {
        super(description);
        this.headerSetInputPort.addPrecondition((Precondition)new SimplePrecondition(this.headerSetInputPort, (MetaData)new ExampleSetMetaData(), false));
        this.cookieSetInputPort.addPrecondition((Precondition)new SimplePrecondition(this.cookieSetInputPort, (MetaData)new ExampleSetMetaData(), false));
        this.getTransformer().addRule((MDTransformationRule)new GenerateFixedExampleSetMDRule(this.headerSetOutputPort, HEADER_SET_CREATOR.getMetaData()));
        this.getTransformer().addRule((MDTransformationRule)new GenerateFixedExampleSetMDRule(this.cookieSetOutputPort, HEADER_SET_CREATOR.getMetaData()));
        this.getTransformer().addRule(this.throughPort.makePassThroughRule());
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        if (!isLicensed) {
            throw new UserError((Operator)this, "toolkit.license_exceeded_functionality");
        }
        RestConnectionConfigurable connectionConfig = this.getConnectionConfig();
        Request.Builder builder = new Request.Builder();
        if (this.isParameterSet(PARAMETER_ENDPOINT)) {
            builder.url(connectionConfig.getBaseURL() + this.getParameterAsString(PARAMETER_ENDPOINT));
        } else {
            builder.url(connectionConfig.getBaseURL());
        }
        RequestBody requestBody = null;
        if (HttpMethod.requiresRequestBody(this.getParameterAsString(PARAMETER_METHOD))) {
            if (MIME_TYPES[0].equals(this.getParameterAsString(PARAMETER_BODY_CONTENT_TYPE)) && this.getParameterAsBoolean(PARAMETER_USE_FORM_EDITOR)) {
                FormBody.Builder formBodyBuilder = new FormBody.Builder();
                for (String[] pair : this.getParameterList(PARAMETER_FORM_EDITOR)) {
                    formBodyBuilder.add(pair[0], pair[1]);
                }
                requestBody = formBodyBuilder.build();
            } else if (this.isParameterSet(PARAMETER_BODY)) {
                requestBody = RequestBody.create(MediaType.parse(this.getParameterAsString(PARAMETER_BODY_CONTENT_TYPE)), this.getParameterAsString(PARAMETER_BODY));
            }
        }
        builder.method(this.getParameterAsString(PARAMETER_METHOD), requestBody);
        List headerList = this.getParameterList(PARAMETER_HEADERS);
        for (String[] pair : headerList) {
            builder.addHeader(pair[0], pair[1]);
        }
        ExampleSet headerSet = (ExampleSet)this.headerSetInputPort.getDataOrNull(ExampleSet.class);
        if (headerSet != null) {
            Attribute nameAttribute = headerSet.getAttributes().get(ATTRIBUTE_HEADER);
            if (nameAttribute == null) {
                throw new UserError((Operator)this, "web_automation.rest.name_attribute_missing");
            }
            if (!nameAttribute.isNominal()) {
                throw new UserError((Operator)this, "web_automation.rest.name_attribute_must_be_nominal");
            }
            Attribute valueAttribute = headerSet.getAttributes().get(ATTRIBUTE_VALUE);
            if (valueAttribute == null) {
                throw new UserError((Operator)this, "web_automation.rest.value_attribute_missing");
            }
            if (!valueAttribute.isNominal()) {
                throw new UserError((Operator)this, "web_automation.rest.value_attribute_must_be_nominal");
            }
            for (Example example : headerSet) {
                if (Double.isNaN(example.getValue(nameAttribute)) || Double.isNaN(example.getValue(valueAttribute))) continue;
                builder.addHeader(example.getNominalValue(nameAttribute), example.getNominalValue(valueAttribute));
            }
        }
        SimpleCookieJar cookieJar = new SimpleCookieJar();
        ExampleSet cookieSet = (ExampleSet)this.cookieSetInputPort.getDataOrNull(ExampleSet.class);
        if (cookieSet != null) {
            Attribute urlAttribute = cookieSet.getAttributes().get(ATTRIBUTE_URL);
            if (urlAttribute == null) {
                throw new UserError((Operator)this, "web_automation.rest.url_attribute_missing");
            }
            if (!urlAttribute.isNominal()) {
                throw new UserError((Operator)this, "web_automation.rest.url_attribute_must_be_nominal");
            }
            Attribute cookieAttribute = cookieSet.getAttributes().get(ATTRIBUTE_COOKIE);
            if (cookieAttribute == null) {
                throw new UserError((Operator)this, "web_automation.rest.cookie_attribute_missing");
            }
            if (!cookieAttribute.isNominal()) {
                throw new UserError((Operator)this, "web_automation.rest.cookie_attribute_must_be_nominal");
            }
            for (Example example : cookieSet) {
                HttpUrl url = HttpUrl.parse(example.getNominalValue(urlAttribute));
                if (url == null) {
                    throw new UserError((Operator)this, "web_automation.rest.cookie_url_illegal", new Object[]{example.getNominalValue(urlAttribute)});
                }
                Cookie cookie = Cookie.parse(url, example.getNominalValue(cookieAttribute));
                if (cookie == null) {
                    throw new UserError((Operator)this, "web_automation.rest.cookie_illegal", new Object[]{example.getNominalValue(urlAttribute), example.getNominalValue(cookieAttribute)});
                }
                cookieJar.storeCookie(url, cookie);
            }
        }
        try {
            Request request = builder.build();
            Response response = HttpConnectionManager.makeCall(connectionConfig, request, this.getParameterAsBoolean(PARAMETER_ENABLE_COMPRESSION), cookieJar);
            ExampleSetCreator creator = HEADER_SET_CREATOR.getInstance();
            creator.setValue(ATTRIBUTE_HEADER, "http-status");
            creator.setValue(ATTRIBUTE_VALUE, response.code() + "");
            creator.commit();
            creator.setValue(ATTRIBUTE_HEADER, "http-url");
            creator.setValue(ATTRIBUTE_VALUE, response.request().url().toString());
            creator.commit();
            Map<String, List<String>> headerMap = response.headers().toMultimap();
            for (Map.Entry entry : headerMap.entrySet()) {
                for (String string : (List)entry.getValue()) {
                    creator.setValue(ATTRIBUTE_HEADER, (String)entry.getKey());
                    creator.setValue(ATTRIBUTE_VALUE, string);
                    creator.commit();
                }
            }
            ExampleSetCreator cookieCreator = COOKIE_SET_CREATOR.getInstance();
            Map<HttpUrl, List<Cookie>> map = cookieJar.getStoredCookies();
            for (Map.Entry entry : map.entrySet()) {
                for (Cookie value : (List)entry.getValue()) {
                    cookieCreator.setValue(ATTRIBUTE_URL, ((HttpUrl)entry.getKey()).toString());
                    cookieCreator.setValue(ATTRIBUTE_COOKIE, value.toString());
                    cookieCreator.commit();
                }
            }
            this.processResponseBody(response);
            this.cookieSetOutputPort.deliver((IOObject)cookieCreator.finish());
            this.headerSetOutputPort.deliver((IOObject)creator.finish());
            this.throughPort.passDataThrough();
        }
        catch (IOException e) {
            throw new UserError((Operator)this, (Throwable)e, "web_automation.io_error", new Object[]{connectionConfig.getBaseURL() + this.getParameterAsString(PARAMETER_ENDPOINT), e.getMessage()});
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e2) {
            throw new UserError((Operator)this, (Throwable)e2, "web_automation.certificate_error", new Object[]{e2.getMessage()});
        }
    }

    protected abstract void processResponseBody(Response var1) throws IOException, UserError, OperatorException;

    protected RestConnectionConfigurable getConnectionConfig() throws UserError {
        try {
            return (RestConnectionConfigurable)ConfigurationManager.getInstance().lookup("RESTConnection", this.getParameterAsString(PARAMETER_CONNECTION), this.getProcess().getRepositoryAccessor());
        }
        catch (ConfigurationException e) {
            throw new UserError((Operator)this, (Throwable)e, "web_automation.retrieve_configurable_failed", new Object[]{this.getParameterAsString(PARAMETER_CONNECTION), e.getMessage()});
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeConfigurable type = new ParameterTypeConfigurable(PARAMETER_CONNECTION, "Select the connection.", "RESTConnection");
        types.add((ParameterType)type);
        type.setOptional(false);
        types.add((ParameterType)new ParameterTypeString(PARAMETER_ENDPOINT, "The endpoint of the RESTful Webservice. Will be added to the base url of the connection.", true));
        types.add((ParameterType)new ParameterTypeList(PARAMETER_HEADERS, "Sets the headers of the http request.", (ParameterType)new ParameterTypeString("name", "The name of the header"), (ParameterType)new ParameterTypeString("value", "The value of the header")));
        types.add((ParameterType)new ParameterTypeCategory(PARAMETER_METHOD, "Select the method for the http call.", HttpConnectionManager.METHODS, 1));
        type = new ParameterTypeStringCategory(PARAMETER_BODY_CONTENT_TYPE, "The content type of the body according to RFC 2045.", MIME_TYPES);
        types.add((ParameterType)type);
        type.setOptional(true);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_METHOD, HttpConnectionManager.METHODS, false, new int[]{0, 3, 4, 5, 6, 7, 8}));
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_METHOD, HttpConnectionManager.METHODS, true, new int[]{HttpConnectionManager.METHOD_PUT, HttpConnectionManager.METHOD_POST, HttpConnectionManager.METHOD_PATCH, HttpConnectionManager.METHOD_PROPPATCH, HttpConnectionManager.METHOD_REPORT}));
        type = new ParameterTypeBoolean(PARAMETER_USE_FORM_EDITOR, "If checked, you can enter the single values of the form instead writing the body manually.", true);
        types.add((ParameterType)type);
        type.registerDependencyCondition((ParameterCondition)new EqualStringCondition((ParameterHandler)this, PARAMETER_BODY_CONTENT_TYPE, false, new String[]{MIME_TYPES[0]}));
        type = new ParameterTypeText(PARAMETER_BODY, "If your method allows a body, you can enter it here.", TextType.PLAIN, true);
        types.add((ParameterType)type);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_METHOD, HttpConnectionManager.METHODS, false, new int[]{0, 3, 4, 5, 6, 7, 8}));
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_METHOD, HttpConnectionManager.METHODS, true, new int[]{HttpConnectionManager.METHOD_PUT, HttpConnectionManager.METHOD_POST, HttpConnectionManager.METHOD_PATCH, HttpConnectionManager.METHOD_PROPPATCH, HttpConnectionManager.METHOD_REPORT}));
        type.registerDependencyCondition((ParameterCondition)new OrParameterCondition((ParameterHandler)this, false, new ParameterCondition[]{new BooleanParameterCondition((ParameterHandler)this, PARAMETER_USE_FORM_EDITOR, false, false), new NonEqualStringCondition((ParameterHandler)this, PARAMETER_BODY_CONTENT_TYPE, false, new String[]{MIME_TYPES[0]})}));
        type = new ParameterTypeList(PARAMETER_FORM_EDITOR, "You can enter the form data here.", (ParameterType)new ParameterTypeString("id", "The id of the form element."), (ParameterType)new ParameterTypeString("value", "The value"));
        types.add((ParameterType)type);
        type.registerDependencyCondition((ParameterCondition)new EqualStringCondition((ParameterHandler)this, PARAMETER_BODY_CONTENT_TYPE, false, new String[]{MIME_TYPES[0]}));
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_USE_FORM_EDITOR, false, true));
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_ENABLE_COMPRESSION, "If checked, the body will be gziped to send data in a compressed way.", false));
        for (ParameterType typeI : types) {
            typeI.setExpert(false);
        }
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitWebAutomationExtension.PRODUCT_INFORMATION;
    }
}

