/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.rest;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.owc.metadata.JSONParserSpecificationMetaData;
import com.owc.objects.JSONParserSpecificationObject;
import com.owc.operator.rest.AbstractSendRequestOperator;
import com.owc.process.ports.NamedOneToOneExtender;
import com.owc.process.ports.NamedPortPairExtender;
import com.owc.tools.JSONTools;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import okhttp3.Response;

public class SendJSONRequestOperator
extends AbstractSendRequestOperator {
    private static JsonFactory JSON_FACTORY = new JsonFactory();
    private NamedOneToOneExtender parseSpecificationExtender = new NamedOneToOneExtender("parse specifications", "example set", this.getInputPorts(), this.getOutputPorts());

    public SendJSONRequestOperator(OperatorDescription description) {
        super(description);
        this.parseSpecificationExtender.start();
        this.getTransformer().addRule(new MDTransformationRule(){

            public void transformMD() {
                for (NamedPortPairExtender.NamedPortPair pair : SendJSONRequestOperator.this.parseSpecificationExtender.getManagedPairs()) {
                    if (!pair.getInputPort().isConnected()) continue;
                    MetaData metaData = pair.getInputPort().getMetaData();
                    if (metaData != null && metaData instanceof JSONParserSpecificationMetaData) {
                        JSONParserSpecificationMetaData specMd = (JSONParserSpecificationMetaData)metaData.clone();
                        pair.getOutputPort().deliverMD((MetaData)specMd.getExampleSetDefinition());
                        continue;
                    }
                    pair.getOutputPort().deliverMD((MetaData)new ExampleSetMetaData());
                }
            }
        });
    }

    @Override
    protected void processResponseBody(Response response) throws IOException, OperatorException {
        List<JSONParserSpecificationObject> parserSpecifications = this.parseSpecificationExtender.getData(JSONParserSpecificationObject.class);
        try (JsonParser jsonParser = JSON_FACTORY.createParser(response.body().byteStream());){
            LinkedHashMap<Integer, ExampleSet> sets = JSONTools.parseJSON(parserSpecifications, jsonParser);
            this.parseSpecificationExtender.deliver(new LinkedList<ExampleSet>(sets.values()));
        }
        catch (JsonParseException e) {
            throw new OperatorException("web_automation.illegal_json", null, new Object[0]);
        }
        catch (IOException e) {
            throw new OperatorException("web_automation.io_error", null, new Object[0]);
        }
        catch (UserError e) {
            e.setOperator((Operator)this);
            throw e;
        }
    }
}

