/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.rest;

import com.owc.io.http.HttpConnectionManager;
import com.owc.io.http.SimpleCookieJar;
import com.owc.license.ProductInformation;
import com.owc.operator.LicensedOperator;
import com.owc.process.ports.metadata.AddFixedAttributeSetMDRule;
import com.owc.process.ports.metadata.AttributeParameterPrecondition;
import com.owc.process.ports.metadata.ParameterBasedAttributeMetaDataSupplier;
import com.owc.rest.RestConnectionConfigurable;
import com.owc.tools.ExampleSetModifier;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.PluginInitWebAutomationExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.operator.ports.metadata.SimplePrecondition;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import com.rapidminer.parameter.ParameterTypeText;
import com.rapidminer.parameter.TextType;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.EqualStringCondition;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.parameter.conditions.NonEqualStringCondition;
import com.rapidminer.parameter.conditions.OrParameterCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.tools.config.ConfigurationException;
import com.rapidminer.tools.config.ConfigurationManager;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import okhttp3.Cookie;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class SendRequestsFromDataOperator
extends LicensedOperator {
    public static final String[] MIME_TYPES = new String[]{"application/x-www-form-urlencoded"};
    public static final String ATTRIBUTE_VALUE = "Value";
    public static final String ATTRIBUTE_HEADER = "Name";
    public static final String ATTRIBUTE_COOKIE = "Cookie";
    public static final String ATTRIBUTE_URL = "URL";
    public static final String PARAMETER_METHOD = "method";
    public static final String PARAMETER_BODY = "body";
    public static final String PARAMETER_ENABLE_COMPRESSION = "enable_compression";
    public static final String PARAMETER_BODY_CONTENT_TYPE = "body_content_type";
    public static final String PARAMETER_HEADERS = "headers";
    public static final String PARAMETER_USE_FORM_EDITOR = "use_form_editor";
    public static final String PARAMETER_FORM_EDITOR = "form_editor";
    public static final String PARAMETER_URL_ATTRIBUTE = "url_attribute";
    public static final String PARAMETER_CONNECTION_ATTRIBUTE = "connection_attribute";
    public static final String PARAMETER_URL_ATTRIBUTE_IS_ABSOLUTE = "is_absolute";
    public static final String PARAMETER_CODE_ATTRIBUTE = "code_attribute";
    public static final String PARAMETER_RESPONSE_BODY_ATTRIBUTE = "response_body_attribute";
    protected InputPort exampleSetInputPort = (InputPort)this.getInputPorts().createPort("example set");
    protected InputPort cookieSetInputPort = (InputPort)this.getInputPorts().createPort("cookie set");
    protected InputPort headerSetInputPort = (InputPort)this.getInputPorts().createPort("header set");
    protected OutputPort exampleSetOutputPort = (OutputPort)this.getOutputPorts().createPort("example set");

    public SendRequestsFromDataOperator(OperatorDescription description) {
        super(description);
        this.exampleSetInputPort.addPrecondition((Precondition)new AttributeParameterPrecondition(this.exampleSetInputPort, this, PARAMETER_URL_ATTRIBUTE, 1));
        this.exampleSetInputPort.addPrecondition((Precondition)new AttributeParameterPrecondition(this.exampleSetInputPort, this, PARAMETER_CONNECTION_ATTRIBUTE, 1));
        this.headerSetInputPort.addPrecondition((Precondition)new SimplePrecondition(this.headerSetInputPort, (MetaData)new ExampleSetMetaData(), false));
        this.cookieSetInputPort.addPrecondition((Precondition)new SimplePrecondition(this.cookieSetInputPort, (MetaData)new ExampleSetMetaData(), false));
        LinkedList<Supplier<AttributeMetaData>> suppliers = new LinkedList<Supplier<AttributeMetaData>>();
        suppliers.add(new ParameterBasedAttributeMetaDataSupplier(this, PARAMETER_CODE_ATTRIBUTE, 3));
        suppliers.add(new ParameterBasedAttributeMetaDataSupplier(this, PARAMETER_RESPONSE_BODY_ATTRIBUTE, 5));
        this.getTransformer().addRule((MDTransformationRule)new AddFixedAttributeSetMDRule(this.exampleSetInputPort, this.exampleSetOutputPort, suppliers));
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        ExampleSet exampleSet;
        Attribute urlAttribute;
        if (!isLicensed) {
            throw new UserError((Operator)this, "toolkit.license_exceeded_functionality");
        }
        SimpleCookieJar cookieJar = new SimpleCookieJar();
        ExampleSet cookieSet = (ExampleSet)this.cookieSetInputPort.getDataOrNull(ExampleSet.class);
        if (cookieSet != null) {
            Attribute urlAttribute2 = cookieSet.getAttributes().get(ATTRIBUTE_URL);
            if (urlAttribute2 == null) {
                throw new UserError((Operator)this, "web_automation.rest.url_attribute_missing");
            }
            if (!urlAttribute2.isNominal()) {
                throw new UserError((Operator)this, "web_automation.rest.url_attribute_must_be_nominal");
            }
            Attribute cookieAttribute = cookieSet.getAttributes().get(ATTRIBUTE_COOKIE);
            if (cookieAttribute == null) {
                throw new UserError((Operator)this, "web_automation.rest.cookie_attribute_missing");
            }
            if (!cookieAttribute.isNominal()) {
                throw new UserError((Operator)this, "web_automation.rest.cookie_attribute_must_be_nominal");
            }
            for (Example example : cookieSet) {
                HttpUrl url = HttpUrl.parse(example.getNominalValue(urlAttribute2));
                if (url == null) {
                    throw new UserError((Operator)this, "web_automation.rest.cookie_url_illegal", new Object[]{example.getNominalValue(urlAttribute2)});
                }
                Cookie cookie = Cookie.parse(url, example.getNominalValue(cookieAttribute));
                if (cookie == null) {
                    throw new UserError((Operator)this, "web_automation.rest.cookie_illegal", new Object[]{example.getNominalValue(urlAttribute2), example.getNominalValue(cookieAttribute)});
                }
                cookieJar.storeCookie(url, cookie);
            }
        }
        ExampleSet headerSet = (ExampleSet)this.headerSetInputPort.getDataOrNull(ExampleSet.class);
        Attribute nameAttribute = null;
        Attribute valueAttribute = null;
        if (headerSet != null) {
            nameAttribute = headerSet.getAttributes().get(ATTRIBUTE_HEADER);
            if (nameAttribute == null) {
                throw new UserError((Operator)this, "web_automation.rest.name_attribute_missing");
            }
            if (!nameAttribute.isNominal()) {
                throw new UserError((Operator)this, "web_automation.rest.name_attribute_must_be_nominal");
            }
            valueAttribute = headerSet.getAttributes().get(ATTRIBUTE_VALUE);
            if (valueAttribute == null) {
                throw new UserError((Operator)this, "web_automation.rest.value_attribute_missing");
            }
            if (!valueAttribute.isNominal()) {
                throw new UserError((Operator)this, "web_automation.rest.value_attribute_must_be_nominal");
            }
        }
        if ((urlAttribute = (exampleSet = (ExampleSet)this.exampleSetInputPort.getData(ExampleSet.class)).getAttributes().get(this.getParameterAsString(PARAMETER_URL_ATTRIBUTE))) == null) {
            throw new UserError((Operator)this, "web_automation.rest.url_request_attribute_missing", new Object[]{this.getParameterAsString(PARAMETER_URL_ATTRIBUTE)});
        }
        if (!urlAttribute.isNominal()) {
            throw new UserError((Operator)this, "web_automation.rest.url_request_attribute_must_be_nominal", new Object[]{this.getParameterAsString(PARAMETER_URL_ATTRIBUTE)});
        }
        Attribute connectionAttribute = null;
        RestConnectionConfigurable fallbackConnection = null;
        if (this.isParameterSet(PARAMETER_CONNECTION_ATTRIBUTE) && !this.getParameterAsString(PARAMETER_CONNECTION_ATTRIBUTE).isEmpty()) {
            connectionAttribute = exampleSet.getAttributes().get(this.getParameterAsString(PARAMETER_CONNECTION_ATTRIBUTE));
            if (connectionAttribute == null) {
                throw new UserError((Operator)this, "web_automation.rest.connection_attribute_unknown", new Object[]{this.getParameterAsString(PARAMETER_CONNECTION_ATTRIBUTE)});
            }
            if (!connectionAttribute.isNominal()) {
                throw new UserError((Operator)this, "web_automation.rest.connection_attribute_must_be_nominal", new Object[]{this.getParameterAsString(PARAMETER_CONNECTION_ATTRIBUTE)});
            }
        } else {
            fallbackConnection = RestConnectionConfigurable.getDefaultConfigurable();
        }
        Attribute responseAttribute = ExampleSetModifier.createAttribute(exampleSet, this.getParameterAsString(PARAMETER_RESPONSE_BODY_ATTRIBUTE), 5, false);
        Attribute codeAttribute = ExampleSetModifier.createAttribute(exampleSet, this.getParameterAsString(PARAMETER_CODE_ATTRIBUTE), 3, false);
        this.getProgress().setTotal(exampleSet.size());
        this.getProgress().setCheckForStop(true);
        int row = 0;
        for (Example example : exampleSet) {
            RestConnectionConfigurable connectionConfig = fallbackConnection;
            if (connectionAttribute != null) {
                try {
                    connectionConfig = (RestConnectionConfigurable)ConfigurationManager.getInstance().lookup("RESTConnection", example.getNominalValue(connectionAttribute), this.getProcess().getRepositoryAccessor());
                }
                catch (ConfigurationException e) {
                    throw new UserError((Operator)this, (Throwable)e, "web_automation.retrieve_configurable_failed", new Object[]{example.getNominalValue(connectionAttribute), e.getMessage()});
                }
            }
            Request.Builder builder = new Request.Builder();
            builder.url(connectionConfig.getBaseURL() + example.getValueAsString(urlAttribute));
            RequestBody requestBody = null;
            if (MIME_TYPES[0].equals(this.getParameterAsString(PARAMETER_BODY_CONTENT_TYPE)) && this.getParameterAsBoolean(PARAMETER_USE_FORM_EDITOR)) {
                FormBody.Builder formBodyBuilder = new FormBody.Builder();
                for (String[] pair : this.getParameterList(PARAMETER_FORM_EDITOR)) {
                    formBodyBuilder.add(pair[0], pair[1]);
                }
                requestBody = formBodyBuilder.build();
            } else if (this.isParameterSet(PARAMETER_BODY)) {
                requestBody = RequestBody.create(MediaType.parse(this.getParameterAsString(PARAMETER_BODY_CONTENT_TYPE)), this.getParameterAsString(PARAMETER_BODY));
            }
            builder.method(this.getParameterAsString(PARAMETER_METHOD), requestBody);
            List headerList = this.getParameterList(PARAMETER_HEADERS);
            for (String[] pair : headerList) {
                builder.addHeader(pair[0], pair[1]);
            }
            if (headerSet != null) {
                for (Example headerExample : headerSet) {
                    if (Double.isNaN(headerExample.getValue(nameAttribute)) || Double.isNaN(headerExample.getValue(valueAttribute))) continue;
                    builder.addHeader(headerExample.getNominalValue(nameAttribute), headerExample.getNominalValue(valueAttribute));
                }
            }
            try {
                Request request = builder.build();
                Response response = HttpConnectionManager.makeCall(connectionConfig, request, this.getParameterAsBoolean(PARAMETER_ENABLE_COMPRESSION), cookieJar.clone());
                example.setValue(codeAttribute, (double)response.code());
                example.setValue(responseAttribute, response.body().string());
            }
            catch (IOException e) {
                throw new UserError((Operator)this, (Throwable)e, "web_automation.io_error", new Object[]{connectionConfig.getBaseURL() + example.getValueAsString(urlAttribute), e.getMessage()});
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e2) {
                throw new UserError((Operator)this, (Throwable)e2, "web_automation.certificate_error", new Object[]{e2.getMessage()});
            }
            this.getProgress().setCompleted(++row);
        }
        this.exampleSetOutputPort.deliver((IOObject)exampleSet);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add((ParameterType)new ParameterTypeAttribute(PARAMETER_URL_ATTRIBUTE, "The attribute containing the url to make a call to.", this.exampleSetInputPort, false, new int[]{1}));
        types.add((ParameterType)new ParameterTypeAttribute(PARAMETER_CONNECTION_ATTRIBUTE, "If this optional attribute is selected, then the attribute needs to contain a name of a REST configurable. This is used for the respective call. The base URL and all rates, authentication is hence used from there. If not, the url attributes is interpreted as absolute URL.", this.exampleSetInputPort, true, new int[]{1}));
        types.add((ParameterType)new ParameterTypeString(PARAMETER_RESPONSE_BODY_ATTRIBUTE, "The attribute name of the newly created attribute that will contain the response body.", "Response"));
        types.add((ParameterType)new ParameterTypeString(PARAMETER_CODE_ATTRIBUTE, "The attribute name of the newly created attribute that will contain the response code.", "ResponseCode"));
        types.add((ParameterType)new ParameterTypeList(PARAMETER_HEADERS, "Sets the headers of the http request.", (ParameterType)new ParameterTypeString("name", "The name of the header"), (ParameterType)new ParameterTypeString("value", "The value of the header")));
        types.add((ParameterType)new ParameterTypeCategory(PARAMETER_METHOD, "Select the method for the http call.", HttpConnectionManager.METHODS, 1));
        ParameterTypeStringCategory type = new ParameterTypeStringCategory(PARAMETER_BODY_CONTENT_TYPE, "The content type of the body according to RFC 2045.", MIME_TYPES);
        types.add((ParameterType)type);
        type.setOptional(true);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_METHOD, HttpConnectionManager.METHODS, false, new int[]{0, 3, 4, 5, 6, 7, 8}));
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_METHOD, HttpConnectionManager.METHODS, true, new int[]{HttpConnectionManager.METHOD_PUT, HttpConnectionManager.METHOD_POST, HttpConnectionManager.METHOD_PATCH, HttpConnectionManager.METHOD_PROPPATCH, HttpConnectionManager.METHOD_REPORT}));
        type = new ParameterTypeBoolean(PARAMETER_USE_FORM_EDITOR, "If checked, you can enter the single values of the form instead writing the body manually.", true);
        types.add((ParameterType)type);
        type.registerDependencyCondition((ParameterCondition)new EqualStringCondition((ParameterHandler)this, PARAMETER_BODY_CONTENT_TYPE, false, new String[]{MIME_TYPES[0]}));
        type = new ParameterTypeText(PARAMETER_BODY, "If your method allows a body, you can enter it here.", TextType.PLAIN, true);
        types.add((ParameterType)type);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_METHOD, HttpConnectionManager.METHODS, false, new int[]{0, 3, 4, 5, 6, 7, 8}));
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_METHOD, HttpConnectionManager.METHODS, true, new int[]{HttpConnectionManager.METHOD_PUT, HttpConnectionManager.METHOD_POST, HttpConnectionManager.METHOD_PATCH, HttpConnectionManager.METHOD_PROPPATCH, HttpConnectionManager.METHOD_REPORT}));
        type.registerDependencyCondition((ParameterCondition)new OrParameterCondition((ParameterHandler)this, false, new ParameterCondition[]{new BooleanParameterCondition((ParameterHandler)this, PARAMETER_USE_FORM_EDITOR, false, false), new NonEqualStringCondition((ParameterHandler)this, PARAMETER_BODY_CONTENT_TYPE, false, new String[]{MIME_TYPES[0]})}));
        type = new ParameterTypeList(PARAMETER_FORM_EDITOR, "You can enter the form data here.", (ParameterType)new ParameterTypeString("id", "The id of the form element."), (ParameterType)new ParameterTypeString("value", "The value"));
        types.add((ParameterType)type);
        type.registerDependencyCondition((ParameterCondition)new EqualStringCondition((ParameterHandler)this, PARAMETER_BODY_CONTENT_TYPE, false, new String[]{MIME_TYPES[0]}));
        type.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_USE_FORM_EDITOR, false, true));
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_ENABLE_COMPRESSION, "If checked, the body will be gziped to send data in a compressed way.", false));
        for (ParameterType typeI : types) {
            typeI.setExpert(false);
        }
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitWebAutomationExtension.PRODUCT_INFORMATION;
    }
}

