/*
 * Decompiled with CFR 0.152.
 */
package com.owc.process.ports;

import com.owc.process.ports.SortedInputPort;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.InputPorts;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.PortException;
import com.rapidminer.operator.ports.PortExtender;
import com.rapidminer.operator.ports.PortOwner;
import com.rapidminer.operator.ports.Ports;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.operator.ports.metadata.SimplePrecondition;
import com.rapidminer.tools.AbstractObservable;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Observable;
import com.rapidminer.tools.Observer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;

public class SortingInputPorts
extends AbstractObservable<Port>
implements InputPorts {
    private final List<InputPort> portList = Collections.synchronizedList(new ArrayList());
    private final Map<String, InputPort> portMap = new HashMap<String, InputPort>();
    private String[] portNames;
    private boolean portNamesValid = false;
    private final PortOwner owner;
    private final Observer<Port> delegatingObserver = new Observer<Port>(){

        public void update(Observable<Port> observable, Port arg) {
            SortingInputPorts.this.fireUpdate(arg);
        }
    };
    private List<PortExtender> portExtenders;

    public SortingInputPorts(PortOwner owner) {
        this.owner = owner;
        this.portNamesValid = false;
    }

    public void addPort(InputPort port) throws PortException {
        if (this.portMap.containsKey(port.getName())) {
            throw new PortException("Port name already used: " + port.getName());
        }
        assert (port.getPorts() == this);
        this.portMap.put(port.getName(), port);
        this.portNamesValid = false;
        port.addObserver(this.delegatingObserver, false);
        String portName = port.getName();
        if (portName.matches(".* [0-9]+")) {
            String portGroupExpression = this.getPortGroupName(portName) + " [0-9]+";
            boolean isGroup = false;
            boolean isAdded = false;
            ListIterator<InputPort> iterator = this.portList.listIterator();
            while (iterator.hasNext()) {
                InputPort existingPort = iterator.next();
                String existingPortName = existingPort.getName();
                if (existingPortName.matches(portGroupExpression)) {
                    isGroup = true;
                    continue;
                }
                if (!isGroup) continue;
                iterator.previous();
                iterator.add(port);
                isAdded = true;
                break;
            }
            if (!isAdded) {
                if (isGroup) {
                    this.portList.add(port);
                } else {
                    this.portList.add(0, port);
                }
            }
        } else {
            this.portList.add(0, port);
        }
        this.fireUpdate(port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePortNames() {
        if (!this.portNamesValid) {
            this.portNames = new String[this.portList.size()];
            int i = 0;
            List<InputPort> list = this.portList;
            synchronized (list) {
                for (Port port : this.portList) {
                    this.portNames[i++] = port.getName();
                }
            }
            this.portNamesValid = true;
        }
    }

    public void removePort(InputPort port) throws PortException {
        if (!this.portList.contains(port) || port.getPorts() != this) {
            throw new PortException("Cannot remove " + port + ".");
        }
        if (port.isConnected()) {
            if (port instanceof OutputPort) {
                ((OutputPort)port).disconnect();
            } else {
                port.getSource().disconnect();
            }
        }
        this.portList.remove(port);
        this.portMap.remove(port.getName());
        port.removeObserver(this.delegatingObserver);
        this.fireUpdate();
    }

    public void removeAll() {
        while (this.getNumberOfPorts() != 0) {
            this.removePort(this.getPortByIndex(0));
        }
    }

    public int getNumberOfPorts() {
        return this.portList.size();
    }

    public InputPort getPortByIndex(int index) {
        return this.portList.get(index);
    }

    public InputPort getPortByName(String name) {
        InputPort port = this.portMap.get(name);
        if (port != null) {
            return port;
        }
        LogService.getRoot().log(Level.FINE, "com.rapidminer.operator.ports.impl.AbstractPorts.port_does_not_exist", name);
        if (this.portExtenders != null) {
            for (PortExtender extender : this.portExtenders) {
                String prefix = extender.getNamePrefix();
                if (!name.startsWith(prefix)) continue;
                LogService.getRoot().log(Level.FINE, "com.rapidminer.operator.ports.impl.AbstractPorts.found_extender", prefix);
                try {
                    int index = Integer.parseInt(name.substring(prefix.length()));
                    extender.ensureMinimumNumberOfPorts(index);
                    InputPort secondTry = this.portMap.get(name);
                    if (secondTry == null) {
                        LogService.getRoot().log(Level.WARNING, "com.rapidminer.operator.ports.impl.AbstractPorts.port_extender_did_not_extend", new Object[]{prefix, index});
                    } else {
                        LogService.getRoot().log(Level.FINE, "com.rapidminer.operator.ports.impl.AbstractPorts.ports_created", this.getAllPorts());
                    }
                    return secondTry;
                }
                catch (NumberFormatException e) {
                    LogService.getRoot().log(Level.WARNING, I18N.getMessage((ResourceBundle)LogService.getRoot().getResourceBundle(), (String)"com.rapidminer.operator.ports.impl.AbstractPorts.extending_error", (Object[])new Object[]{prefix, e}), e);
                    return null;
                }
            }
        }
        return null;
    }

    public String[] getPortNames() {
        this.updatePortNames();
        return this.portNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InputPort> getAllPorts() {
        List<InputPort> list = this.portList;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<InputPort>(this.portList));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMetaDataDescription() {
        StringBuilder b = new StringBuilder();
        List<InputPort> list = this.portList;
        synchronized (list) {
            for (Port port : this.portList) {
                b.append(port.getName());
                b.append(": ");
                b.append(port.getMetaData());
                b.append("; ");
            }
        }
        return b.toString();
    }

    public PortOwner getOwner() {
        return this.owner;
    }

    public boolean containsPort(InputPort port) {
        return this.portList.contains(port);
    }

    public void renamePort(InputPort port, String newName) {
        if (this.portMap.containsKey(newName)) {
            throw new PortException("Port name already used: " + port.getName());
        }
        this.portMap.remove(port.getName());
        ((SortedInputPort)port).setName(newName);
        this.portMap.put(newName, port);
    }

    public void clear(int clearFlags) {
        for (InputPort port : this.getAllPorts()) {
            port.clear(clearFlags);
        }
    }

    public IOContainer createIOContainer(boolean onlyConnected, boolean omitEmptyResults) {
        LinkedList<IOObject> output = new LinkedList<IOObject>();
        for (Port port : this.getAllPorts()) {
            if (onlyConnected && !port.isConnected()) continue;
            IOObject data = port.getAnyDataOrNull();
            if (omitEmptyResults) {
                if (data == null) continue;
                output.add(data);
                continue;
            }
            output.add(data);
        }
        return new IOContainer(output);
    }

    public IOContainer createIOContainer(boolean onlyConnected) {
        return this.createIOContainer(onlyConnected, true);
    }

    public void pushDown(InputPort port) {
    }

    public void registerPortExtender(PortExtender extender) {
        if (this.portExtenders == null) {
            this.portExtenders = new LinkedList<PortExtender>();
        }
        this.portExtenders.add(extender);
    }

    public void unlockPortExtenders() {
        if (this.portExtenders != null) {
            for (PortExtender extender : this.portExtenders) {
                extender.ensureMinimumNumberOfPorts(0);
            }
        }
    }

    public void freeMemory() {
        for (Port port : this.getAllPorts()) {
            port.freeMemory();
        }
    }

    public int getNumberOfConnectedPorts() {
        int count = 0;
        for (Port port : this.getAllPorts()) {
            if (!port.isConnected()) continue;
            ++count;
        }
        return count;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (String port : this.getPortNames()) {
            if (first) {
                first = false;
            } else {
                b.append(", ");
            }
            b.append(port);
        }
        return b.toString();
    }

    public void checkPreconditions() {
        for (InputPort port : this.getAllPorts()) {
            port.checkPreconditions();
        }
    }

    public InputPort createPort(String name) {
        return this.createPort(name, true);
    }

    public InputPort createPort(String name, boolean add) {
        SortedInputPort in = new SortedInputPort((Ports<? extends Port>)this, name, true);
        if (add) {
            this.addPort((InputPort)in);
        }
        return in;
    }

    public InputPort createPassThroughPort(String name) {
        SortedInputPort in = new SortedInputPort((Ports<? extends Port>)this, name, false);
        this.addPort((InputPort)in);
        return in;
    }

    public InputPort createPort(String name, Class<? extends IOObject> clazz) {
        return this.createPort(name, new MetaData(clazz));
    }

    public InputPort createPort(String name, MetaData metaData) {
        InputPort in = this.createPort(name);
        in.addPrecondition((Precondition)new SimplePrecondition(in, metaData));
        return in;
    }

    public void disconnectAll() {
        this.disconnectAllBut(null);
    }

    public void disconnectAllBut(List<Operator> exceptions) {
        boolean success;
        block0: do {
            success = false;
            for (InputPort port : this.getAllPorts()) {
                Operator sourceOp;
                if (!port.isConnected()) continue;
                OutputPort source = port.getSource();
                boolean isException = false;
                if (exceptions != null && exceptions.contains(sourceOp = source.getPorts().getOwner().getOperator())) {
                    isException = true;
                }
                if (isException) continue;
                source.disconnect();
                success = true;
                continue block0;
            }
        } while (success);
    }

    private String getPortGroupName(String portName) {
        int lastIndexOf = portName.lastIndexOf(" ");
        if (lastIndexOf > -1) {
            return portName.substring(0, lastIndexOf);
        }
        return portName;
    }
}

