/*
 * Decompiled with CFR 0.152.
 */
package com.owc.process.ports.metadata;

import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.ports.IncompatibleMDClassException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.MetaDataError;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;

public class AddFixedAttributeSetMDRule
implements MDTransformationRule {
    private List<Supplier<AttributeMetaData>> addedAttributeSuppliers = new LinkedList<Supplier<AttributeMetaData>>();
    private InputPort inputPort;
    private OutputPort outputPort;

    public AddFixedAttributeSetMDRule(InputPort inputPort, OutputPort outputPort, AttributeMetaData[] amds) {
        this(inputPort, outputPort, amds, null);
    }

    public AddFixedAttributeSetMDRule(InputPort inputPort, OutputPort outputPort, AttributeMetaData[] amds, List<Supplier<AttributeMetaData>> suppliers) {
        for (final AttributeMetaData amd : amds) {
            this.addedAttributeSuppliers.add(new Supplier<AttributeMetaData>(){

                @Override
                public AttributeMetaData get() {
                    return amd;
                }
            });
        }
        if (suppliers != null) {
            for (Supplier supplier : suppliers) {
                this.addedAttributeSuppliers.add(supplier);
            }
        }
        this.inputPort = inputPort;
        this.outputPort = outputPort;
    }

    public AddFixedAttributeSetMDRule(InputPort inputPort, OutputPort outputPort, List<Supplier<AttributeMetaData>> supplier) {
        this(inputPort, outputPort, new AttributeMetaData[0], supplier);
    }

    public void transformMD() {
        ExampleSetMetaData clone;
        try {
            clone = (ExampleSetMetaData)this.inputPort.getMetaData(ExampleSetMetaData.class);
        }
        catch (IncompatibleMDClassException e) {
            this.inputPort.addError((MetaDataError)new SimpleMetaDataError(ProcessSetupError.Severity.ERROR, (Port)this.inputPort, "wrong_data_type", new Object[0]));
            clone = new ExampleSetMetaData();
        }
        clone.addToHistory(this.outputPort);
        for (Supplier<AttributeMetaData> supplier : this.addedAttributeSuppliers) {
            clone.addAttribute(supplier.get());
        }
        this.outputPort.deliverMD(this.modifyMetaData(clone));
    }

    public MetaData modifyMetaData(ExampleSetMetaData unmodifiedMetaData) {
        return unmodifiedMetaData;
    }
}

