/*
 * Decompiled with CFR 0.152.
 */
package com.owc.rest;

import com.owc.io.http.AbstractHTTPConnectionConfigurable;
import java.io.File;
import java.util.HashMap;

public class RestConnectionConfigurable
extends AbstractHTTPConnectionConfigurable {
    public static final String TYPE_ID = "RESTConnection";

    public String getTypeId() {
        return TYPE_ID;
    }

    @Override
    public String getUser() {
        return this.getParameter("username");
    }

    @Override
    public String getBaseURL() {
        return this.getParameter("connection_base_url");
    }

    @Override
    public String getPassword() {
        return this.getParameter("password");
    }

    @Override
    public int getAuthenticationMethod() {
        String method = this.getParameter("authentication_method");
        for (int i = 0; i < AbstractHTTPConnectionConfigurable.AUTHENTICATION_METHODS.length; ++i) {
            if (!AbstractHTTPConnectionConfigurable.AUTHENTICATION_METHODS[i].equals(method)) continue;
            return i;
        }
        return 0;
    }

    @Override
    public String getToken() {
        return this.getParameter("token");
    }

    @Override
    public long getConnectTimeout() {
        return Integer.valueOf(this.getParameter("connection_timeout")).intValue();
    }

    @Override
    public long getResponseTimeout() {
        return Integer.valueOf(this.getParameter("response_timeout")).intValue();
    }

    @Override
    public int getRateLimit() {
        return Integer.valueOf(this.getParameter("rate_limit"));
    }

    @Override
    public boolean isCacheEnabled() {
        return Boolean.valueOf(this.getParameter("enable_cache"));
    }

    public static final RestConnectionConfigurable getDefaultConfigurable() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("rate_limit", "0");
        map.put("response_timeout", "10");
        map.put("connection_timeout", "10");
        map.put("token", "");
        map.put("authentication_method", AbstractHTTPConnectionConfigurable.AUTHENTICATION_METHODS[0]);
        map.put("connection_base_url", "");
        map.put("password", "");
        map.put("username", "");
        RestConnectionConfigurable configurable = new RestConnectionConfigurable();
        configurable.configure(map);
        return configurable;
    }

    @Override
    public boolean addCertificate() {
        return Boolean.valueOf(this.getParameter("add_certificate"));
    }

    @Override
    public String getCertificateType() {
        return this.getParameter("certificate_type");
    }

    @Override
    public File getCertificate() {
        return new File(this.getParameter("certificate"));
    }

    @Override
    public String getPassphrase() {
        return this.getParameter("passphrase");
    }
}

