/*
 * Decompiled with CFR 0.152.
 */
package com.owc.rest;

import com.owc.io.http.AbstractHTTPConnectionConfigurable;
import com.owc.rest.RestConnectionConfigurable;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypePassword;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.AndParameterCondition;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.EqualStringCondition;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.tools.config.AbstractConfigurator;
import java.util.LinkedList;
import java.util.List;

public class RestConnectionConfigurator
extends AbstractConfigurator<RestConnectionConfigurable> {
    public static final String PARAMETER_CONNECTION_BASE_URL = "connection_base_url";
    public static final String PARAMETER_CONNECTION_USERNAME = "username";
    public static final String PARAMETER_CONNECTION_PASSWORD = "password";
    public static final String PARAMETER_CONNECT_TIMEOUT = "connection_timeout";
    public static final String PARAMETER_RESPONSE_TIMEOUT = "response_timeout";
    public static final String PARAMETER_ENABLE_CACHE = "enable_cache";
    public static final String PARAMETER_AUTHENTICATION_METHOD = "authentication_method";
    public static final String PARAMETER_TOKEN = "token";
    public static final String PARAMETER_RATE_LIMIT = "rate_limit";
    public static final String PARAMETER_CERTIFCATE_TYPE = "certificate_type";
    public static final String PARAMETER_ADD_CERTIFICATE = "add_certificate";
    public static final String PARAMETER_CERTIFICATE = "certificate";
    public static final String PARAMETER_PASSPHRASE = "passphrase";
    public static final String[] CERTIFICATE_TYPES = new String[]{"PKCS12"};
    public static final int CERTIFICATE_TYPE_INDEX_PFX = 0;

    public Class<RestConnectionConfigurable> getConfigurableClass() {
        return RestConnectionConfigurable.class;
    }

    public String getTypeId() {
        return "RESTConnection";
    }

    public String getI18NBaseKey() {
        return "rest.connection";
    }

    public List<ParameterType> getParameterTypes(ParameterHandler parameterHandler) {
        LinkedList<ParameterType> list = new LinkedList<ParameterType>();
        list.add((ParameterType)new ParameterTypeString(PARAMETER_CONNECTION_BASE_URL, "The url to the hosting server instance."));
        list.add((ParameterType)new ParameterTypeCategory(PARAMETER_AUTHENTICATION_METHOD, "Here you can select an authentication method for your convenience. Please not that you can implement any scheme with iterated calls on operator level.", AbstractHTTPConnectionConfigurable.AUTHENTICATION_METHODS, 0));
        ParameterTypeString type = new ParameterTypeString(PARAMETER_CONNECTION_USERNAME, "The username for the connection.");
        list.add((ParameterType)type);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition(parameterHandler, PARAMETER_AUTHENTICATION_METHOD, AbstractHTTPConnectionConfigurable.AUTHENTICATION_METHODS, true, new int[]{1}));
        type = new ParameterTypePassword(PARAMETER_CONNECTION_PASSWORD, "The password for this user.");
        list.add((ParameterType)type);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition(parameterHandler, PARAMETER_AUTHENTICATION_METHOD, AbstractHTTPConnectionConfigurable.AUTHENTICATION_METHODS, true, new int[]{1}));
        type = new ParameterTypePassword(PARAMETER_TOKEN, "This is the OAuth token used to connect to the webservice, if configured.");
        list.add((ParameterType)type);
        type.registerDependencyCondition((ParameterCondition)new EqualTypeCondition(parameterHandler, PARAMETER_AUTHENTICATION_METHOD, AbstractHTTPConnectionConfigurable.AUTHENTICATION_METHODS, true, new int[]{2}));
        list.add((ParameterType)new ParameterTypeInt(PARAMETER_CONNECT_TIMEOUT, "The timeout in seconds for establishing connections.", 1, Integer.MAX_VALUE, 60));
        list.add((ParameterType)new ParameterTypeInt(PARAMETER_RESPONSE_TIMEOUT, "The timeout in seconds waiting for a response.", 1, Integer.MAX_VALUE, 60));
        list.add((ParameterType)new ParameterTypeInt(PARAMETER_RATE_LIMIT, "The number of milliseconds between each single call. 0 disables any waiting.", 0, Integer.MAX_VALUE, 0));
        list.add((ParameterType)new ParameterTypeBoolean(PARAMETER_ENABLE_CACHE, "Enable built in caching.", true));
        type = new ParameterTypeBoolean(PARAMETER_ADD_CERTIFICATE, "Allows you to add a certificate to your request. In some cases they are used to avoid other authentication method.", false);
        EqualStringCondition httpsBaseUrl = new EqualStringCondition(parameterHandler, PARAMETER_CONNECTION_BASE_URL, false, new String[]{""}){

            public boolean isConditionFullfilled() {
                try {
                    String baseUrl = this.parameterHandler.getParameterAsString(this.conditionParameter);
                    if (baseUrl != null && baseUrl.toLowerCase().startsWith("https")) {
                        return true;
                    }
                }
                catch (UndefinedParameterError undefinedParameterError) {
                    // empty catch block
                }
                return false;
            }
        };
        type.registerDependencyCondition((ParameterCondition)httpsBaseUrl);
        list.add((ParameterType)type);
        type = new ParameterTypeCategory(PARAMETER_CERTIFCATE_TYPE, "Please select the type of certificate you want to add to your request.", CERTIFICATE_TYPES, 0);
        type.registerDependencyCondition((ParameterCondition)new AndParameterCondition(parameterHandler, true, new ParameterCondition[]{httpsBaseUrl, new BooleanParameterCondition(parameterHandler, PARAMETER_ADD_CERTIFICATE, true, true)}));
        list.add((ParameterType)type);
        type = new ParameterTypeFile(PARAMETER_CERTIFICATE, "Please select your certificate file.", true, new String[]{".p12"});
        type.registerDependencyCondition((ParameterCondition)new AndParameterCondition(parameterHandler, true, new ParameterCondition[]{httpsBaseUrl, new BooleanParameterCondition(parameterHandler, PARAMETER_ADD_CERTIFICATE, true, true)}));
        list.add((ParameterType)type);
        type = new ParameterTypeString(PARAMETER_PASSPHRASE, "Please paste your passphrase with which your certificate is protected. Leave empty if no passphrase is set.", true, false);
        type.registerDependencyCondition((ParameterCondition)new AndParameterCondition(parameterHandler, false, new ParameterCondition[]{httpsBaseUrl, new BooleanParameterCondition(parameterHandler, PARAMETER_ADD_CERTIFICATE, false, true)}));
        list.add((ParameterType)type);
        for (ParameterType typeI : list) {
            typeI.setExpert(false);
        }
        return list;
    }
}

