/*
 * Decompiled with CFR 0.152.
 */
package com.owc.tools;

import com.owc.tools.CSVIterator;
import com.owc.tools.ExampleSetCreator;
import com.owc.tools.Interruptor;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.ProcessStoppedException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.TimeZone;

public class CSVParser {
    public static final ThreadLocal<SimpleDateFormat> DEFAULT_DATE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            format.setTimeZone(TimeZone.getTimeZone("UTC"));
            return format;
        }
    };

    public static void formatExample(PrintStream stream, Example example, Attribute[] attributes, boolean useQuotes, char quote, char escChar, String splitChar, DateFormat dateFormat) {
        String currentSplitChar = "";
        for (Attribute att : attributes) {
            stream.append(currentSplitChar);
            currentSplitChar = splitChar;
            if (att.isNominal()) {
                String value = useQuotes ? CSVParser.quoteAndEscape(example.getNominalValue(att), quote, escChar) : example.getNominalValue(att);
                stream.append(value);
                continue;
            }
            if (att.isNumerical()) {
                stream.append(String.valueOf(example.getValue(att)));
                continue;
            }
            if (Double.isNaN(example.getValue(att))) {
                stream.append("NaN");
                continue;
            }
            String date = dateFormat != null ? (useQuotes ? CSVParser.quoteAndEscape(dateFormat.format(example.getDateValue(att)), quote, escChar) : dateFormat.format(example.getDateValue(att))) : String.valueOf(Double.doubleToLongBits(example.getValue(att)));
            stream.append(date);
        }
        stream.println();
    }

    public static String formatExample(Example example, Attribute[] attributes, boolean useQuotes, char quote, char escChar, String splitChar, DateFormat parser) {
        StringBuilder stringBuilder = new StringBuilder();
        String currentSplitChar = "";
        for (Attribute att : attributes) {
            stringBuilder.append(currentSplitChar);
            currentSplitChar = splitChar;
            if (att.isNominal()) {
                String value = useQuotes ? CSVParser.quoteAndEscape(example.getNominalValue(att), quote, escChar) : example.getNominalValue(att);
                stringBuilder.append(value);
                continue;
            }
            if (att.isNumerical()) {
                stringBuilder.append(String.valueOf(example.getValue(att)));
                continue;
            }
            if (Double.isNaN(example.getValue(att))) {
                stringBuilder.append("NaN");
                continue;
            }
            String date = parser != null ? (useQuotes ? CSVParser.quoteAndEscape(parser.format(example.getDateValue(att)), quote, escChar) : parser.format(example.getDateValue(att))) : String.valueOf(Double.doubleToLongBits(example.getValue(att)));
            stringBuilder.append(date);
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public static String quoteAndEscape(String nominalValue, char quote, char escChar) {
        StringBuilder builder = new StringBuilder(nominalValue.length() + nominalValue.length() >> 7);
        builder.append(quote);
        char[] characters = nominalValue.toCharArray();
        for (int i = 0; i < characters.length; ++i) {
            char character = characters[i];
            if (character == quote) {
                builder.append(escChar);
                builder.append(quote);
                continue;
            }
            if (character == escChar) {
                builder.append(escChar);
                builder.append(escChar);
                continue;
            }
            if (character == '\n') {
                builder.append(escChar);
                builder.append('n');
                continue;
            }
            if (character == '\r') continue;
            builder.append(character);
        }
        builder.append(quote);
        return builder.toString();
    }

    public static String formatHeader(Attribute[] attributes, boolean useQuotes, char quote, char escapeCharacter, String splitCharacter, DateFormat dateFormat) {
        StringBuilder builder = new StringBuilder();
        String currentSplitCharacter = "";
        for (Attribute attribute : attributes) {
            builder.append(currentSplitCharacter);
            builder.append(CSVParser.quoteAndEscape(attribute.getName(), quote, escapeCharacter));
            currentSplitCharacter = splitCharacter;
        }
        builder.append("\n");
        return builder.toString();
    }

    public static void formatHeader(PrintStream stream, Attribute[] attributes, boolean useQuotes, char quote, char escapeCharacter, String splitCharacter, DateFormat dateFormat) {
        String currentSplitCharacter = "";
        for (Attribute attribute : attributes) {
            stream.append(currentSplitCharacter);
            stream.append(CSVParser.quoteAndEscape(attribute.getName(), quote, escapeCharacter));
            currentSplitCharacter = splitCharacter;
        }
        stream.println();
    }

    public static DateFormat getDefaultFormat() {
        return DEFAULT_DATE_FORMAT.get();
    }

    public static ExampleSet parse(InputStream in, String[] attributeNames, int[] valueTypes, boolean hasAttributeNames, boolean useQuotes, char quote, char escapeCharacter, char splitCharacter, char commentCharacter, DateFormat dateFormat, Charset charset, Interruptor interruptor) throws IOException, ParseException, ProcessStoppedException, NumberFormatException {
        ExampleSetCreator creator = new ExampleSetCreator(attributeNames, valueTypes);
        CSVIterator iterator = new CSVIterator(in, useQuotes, quote, escapeCharacter, splitCharacter, commentCharacter, charset);
        if (hasAttributeNames) {
            for (String attributeName : attributeNames) {
                String readAttributeName;
                if (!iterator.hasNext() || attributeName.equals(readAttributeName = iterator.next().trim())) continue;
                throw new IOException("File format invalid");
            }
            String lineBreak = iterator.next();
            if (lineBreak != null) {
                throw new IOException("File format invalid");
            }
        }
        int column = 0;
        int row = 0;
        while (iterator.hasNext()) {
            String value = iterator.next();
            if (value == null) {
                column = 0;
                if (++row % 5000 == 0) {
                    interruptor.checkForStop();
                }
                creator.commit();
                continue;
            }
            if (valueTypes[column] == 7 || valueTypes[column] == 6 || valueTypes[column] == 1 || valueTypes[column] == 5) {
                creator.setValue(attributeNames[column], value);
            } else if (valueTypes[column] == 3) {
                creator.setValue(attributeNames[column], (int)Double.parseDouble(value));
            } else if (valueTypes[column] == 2 || valueTypes[column] == 4) {
                creator.setValue(attributeNames[column], Double.parseDouble(value));
            } else if (valueTypes[column] == 10 || valueTypes[column] == 9 || valueTypes[column] == 11) {
                if (dateFormat != null) {
                    creator.setValue(attributeNames[column], dateFormat.parse(value).toInstant().toEpochMilli());
                } else {
                    creator.setValue(attributeNames[column], Long.valueOf(value).longValue());
                }
            }
            ++column;
        }
        return creator.finish();
    }

    public static Attribute[] getHeaderAttributes(ExampleSet set) {
        Attribute[] attributes = new Attribute[set.getAttributes().allSize()];
        Iterator iterator = set.getAttributes().allAttributes();
        int i = 0;
        while (iterator.hasNext()) {
            attributes[i++] = (Attribute)iterator.next();
        }
        return attributes;
    }
}

