/*
 * Decompiled with CFR 0.152.
 */
package com.owc.tools;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import java.util.Iterator;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.linear.AbstractRealMatrix;
import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;

public class ExampleSetMatrix
extends AbstractRealMatrix {
    private ExampleSet exampleSet;
    private Attribute[] attributes;

    public ExampleSetMatrix(ExampleSet exampleSet) {
        this.exampleSet = exampleSet;
        this.attributes = new Attribute[exampleSet.getAttributes().size()];
        int i = 0;
        Iterator iterator = exampleSet.getAttributes().iterator();
        while (iterator.hasNext()) {
            Attribute attribute;
            this.attributes[i] = attribute = (Attribute)iterator.next();
            ++i;
        }
    }

    public int getRowDimension() {
        return this.exampleSet.size();
    }

    public int getColumnDimension() {
        return this.attributes.length;
    }

    public RealMatrix createMatrix(int rowDimension, int columnDimension) throws NotStrictlyPositiveException {
        return new BlockRealMatrix(rowDimension, columnDimension);
    }

    public RealMatrix copy() {
        BlockRealMatrix matrix = new BlockRealMatrix(this.getRowDimension(), this.getColumnDimension());
        return matrix.add((RealMatrix)this);
    }

    public double getEntry(int row, int column) throws OutOfRangeException {
        return this.exampleSet.getExample(row).getValue(this.attributes[column]);
    }

    public void setEntry(int row, int column, double value) throws OutOfRangeException {
        this.exampleSet.getExample(row).setValue(this.attributes[column], value);
    }
}

