/*
 * Decompiled with CFR 0.152.
 */
package com.owc.tools;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.owc.json.Parser;
import com.owc.json.actions.ParseAction;
import com.owc.objects.JSONParserSpecificationObject;
import com.owc.tools.ExampleSetCreator;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.UserError;
import com.rapidminer.tools.container.Pair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

public class JSONTools {
    public static LinkedHashMap<Integer, ExampleSetCreator> createCreators(List<JSONParserSpecificationObject> parserSpecifications) {
        LinkedHashMap<Integer, ExampleSetCreator> creators = new LinkedHashMap<Integer, ExampleSetCreator>();
        for (JSONParserSpecificationObject specification : parserSpecifications) {
            creators.put(specification.getID(), specification.getExampleSetCreator());
        }
        return creators;
    }

    public static LinkedHashMap<Integer, ExampleSet> parseJSON(List<JSONParserSpecificationObject> parserSpecifications, JsonParser jsonParser) throws UserError, JsonParseException, IOException {
        LinkedHashMap<Integer, ExampleSetCreator> creators = JSONTools.createCreators(parserSpecifications);
        return JSONTools.parseJSON(parserSpecifications, jsonParser, creators);
    }

    public static LinkedHashMap<Integer, ExampleSet> parseJSON(List<JSONParserSpecificationObject> parserSpecifications, JsonParser jsonParser, LinkedHashMap<Integer, ExampleSetCreator> creators) throws UserError, JsonParseException, IOException {
        ArrayList<ParseAction> parseActions = new ArrayList<ParseAction>();
        ArrayList<ParseAction> leaveActions = new ArrayList<ParseAction>();
        for (JSONParserSpecificationObject jSONParserSpecificationObject : parserSpecifications) {
            parseActions.addAll(jSONParserSpecificationObject.getParseActions());
            leaveActions.addAll(jSONParserSpecificationObject.getLeaveActions());
        }
        HashMap<Pair<ParseAction, Integer>, Integer> rowAffectionScopes = new HashMap<Pair<ParseAction, Integer>, Integer>();
        for (ParseAction action : parseActions) {
            rowAffectionScopes.put((Pair<ParseAction, Integer>)new Pair((Object)action, (Object)action.getSetID()), creators.get(action.getSetID()).size());
        }
        Parser parser = new Parser();
        return parser.parse(jsonParser, creators, parseActions, leaveActions, rowAffectionScopes);
    }
}

