/*
 * Decompiled with CFR 0.152.
 */
package com.altair.yassos.client;

import com.altair.relocation.yassos.com.fasterxml.jackson.databind.ObjectMapper;
import com.altair.relocation.yassos.okhttp3.Call;
import com.altair.relocation.yassos.okhttp3.Headers;
import com.altair.relocation.yassos.okhttp3.HttpUrl;
import com.altair.relocation.yassos.okhttp3.MediaType;
import com.altair.relocation.yassos.okhttp3.MultipartBody;
import com.altair.relocation.yassos.okhttp3.OkHttpClient;
import com.altair.relocation.yassos.okhttp3.Request;
import com.altair.relocation.yassos.okhttp3.RequestBody;
import com.altair.relocation.yassos.okhttp3.Response;
import com.altair.relocation.yassos.okio.BufferedSink;
import com.altair.relocation.yassos.okio.Okio;
import com.altair.relocation.yassos.org.apache.commons.io.FileUtils;
import com.altair.relocation.yassos.org.apache.commons.lang3.StringUtils;
import com.altair.yassos.client.YassosAccountAuthProvider;
import com.altair.yassos.client.YassosAdminAuthProvider;
import com.altair.yassos.client.YassosInteractiveAuthProvider;
import com.altair.yassos.client.constant.ContainerContentsOrderBy;
import com.altair.yassos.client.constant.ContainerContentsOrderDirection;
import com.altair.yassos.client.constant.ContainerPermissionPrivilege;
import com.altair.yassos.client.constant.ErrorCode;
import com.altair.yassos.client.error.ChecksumException;
import com.altair.yassos.client.error.ClientException;
import com.altair.yassos.client.request.CreateAccountRequest;
import com.altair.yassos.client.request.CreateContainerPermissionRequest;
import com.altair.yassos.client.request.CreateContainerRequest;
import com.altair.yassos.client.request.UpdateContainerPermissionRequest;
import com.altair.yassos.client.response.AccountResponse;
import com.altair.yassos.client.response.AccountsResponse;
import com.altair.yassos.client.response.ContainerContentsResponse;
import com.altair.yassos.client.response.ContainerPermissionResponse;
import com.altair.yassos.client.response.ContainerPermissionsResponse;
import com.altair.yassos.client.response.ContainerResponse;
import com.altair.yassos.client.response.ContainersResponse;
import com.altair.yassos.client.response.HealthResponse;
import com.altair.yassos.client.response.InfoResponse;
import com.altair.yassos.client.util.Assert;
import com.altair.yassos.client.util.ChecksumUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class YassosHttpClient
implements AutoCloseable {
    public static final String HEADER_ETAG = "Etag";
    public static final String HEADER_X_OBJECT_FILE_NAME = "X-Object-File-Name";
    public static final String HEADER_X_OBJECT_FILE_BYTES = "X-Object-File-Bytes";
    public static final String HEADER_X_OBJECT_VERSION = "X-Object-Version";
    public static final String HEADER_X_OBJECT_META_PREFIX = "X-Object-Meta-";
    public static final String HEADER_X_OBJECT_DELETE_AT = "X-Object-Delete-At";
    public static final String HEADER_X_OBJECT_DELETE_AFTER = "X-Object-Delete-After";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_CONTENT_TYPE_APPLICATION_JSON_VALUE = "application/json";
    private static final String ASSERT_AUTH_PROVIDER_CANNOT_BE_NULL = "'authProvider' cannot be null";
    private static final String ASSERT_ACCOUNT_NAME_CANNOT_BE_BLANK = "'accountName' cannot be blank";
    private static final String ASSERT_CONTAINER_NAME_CANNOT_BE_BLANK = "'containerName' cannot be blank";
    private static final String ASSERT_OBJECT_NAME_CANNOT_BE_BLANK = "'objectName' cannot be blank";
    private static final String ASSERT_METADATA_KEY_CANNOT_BE_BLANK = "'metadataKey' cannot be blank";
    private static final String ASSERT_METADATA_KEY_ALPHA_NUMERIC = "'metadataKey' can only contain alpha numeric characters or dashes";
    private static final String ASSERT_METADATA_VALUE_CANNOT_BE_BLANK = "'metadataValue' cannot be blank";
    private static final String ASSERT_PRIVILEGE_CANNOT_BE_NULL = "'privilege' cannot be null";
    private static final String ASSERT_PERMISSION_ID_CANNOT_BE_NULL = "'permissionId' cannot be null";
    private static final String ASSERT_SOURCE_CANNOT_BE_NULL = "'source' cannot be null";
    private static final String ASSERT_ERROR_CODE_CANNOT_BE_GREATER_THAN_299 = "'errorCode' cannot be greater than 299";
    private static final String ERROR_REASON_FILE_CREATION = "Dummy file creation failed. Reason: %s";
    private static final String ERROR_REASON_IO = "I/O exception: Reason: %s";
    private static final String ERROR_REASON_ETAG_CALCULATION = "Etag cannot be calculated: Reason: %s";
    private static final String API_VERSION_PREFIX = "api/v1";
    private static final String API_CONTAINER_PERMISSIONS_PATH = "container-permissions";
    private static final String QUERY_PARAM_PREFIX = "prefix";
    private static final String QUERY_PARAM_ORDER_BY = "orderBy";
    private static final String QUERY_PARAM_ORDER_DIRECTION = "orderDirection";
    private static final String QUERY_PARAM_LATEST = "latest";
    private static final MediaType MEDIA_TYPE_JSON = MediaType.parse("application/json");
    private static final MediaType MEDIA_TYPE_OCTET_STREAM = MediaType.parse("application/octet-stream");
    private static final String FORM_FILE_KEY = "file";
    private static final Pattern ALLOWED_HEADER_KEY_PATTERN = Pattern.compile("^[a-zA-Z0-9-]*$");
    private final String url;
    private final int connectTimeout;
    private final int readTimeout;
    private final int writeTimeout;
    private final OkHttpClient client;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public YassosHttpClient(String url) {
        this.url = url;
        this.connectTimeout = 0;
        this.readTimeout = 0;
        this.writeTimeout = 0;
        this.client = new OkHttpClient.Builder().writeTimeout(this.writeTimeout, TimeUnit.SECONDS).readTimeout(this.readTimeout, TimeUnit.SECONDS).connectTimeout(this.connectTimeout, TimeUnit.SECONDS).build();
    }

    public YassosHttpClient(String url, int connectTimeout, int readTimeout, int writeTimeout) {
        this.url = url;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.writeTimeout = writeTimeout;
        this.client = new OkHttpClient.Builder().writeTimeout(this.writeTimeout, TimeUnit.SECONDS).readTimeout(this.readTimeout, TimeUnit.SECONDS).connectTimeout(this.connectTimeout, TimeUnit.SECONDS).build();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Map<String, List<String>> objectDownload(String accountName, String containerName, YassosAccountAuthProvider authProvider, File target, String objectName, Integer version) throws ClientException {
        Assert.hasText(accountName, ASSERT_ACCOUNT_NAME_CANNOT_BE_BLANK);
        Assert.hasText(containerName, ASSERT_CONTAINER_NAME_CANNOT_BE_BLANK);
        Assert.notNull(authProvider, ASSERT_AUTH_PROVIDER_CANNOT_BE_NULL);
        Assert.notNull(target, ASSERT_SOURCE_CANNOT_BE_NULL);
        Assert.hasText(objectName, ASSERT_OBJECT_NAME_CANNOT_BE_BLANK);
        String endpoint = String.format("%s/%s/%s/%s/%s", this.url, API_VERSION_PREFIX, accountName, containerName, objectName);
        Headers.Builder headerBuilder = new Headers.Builder();
        if (!authProvider.skipHeader()) {
            headerBuilder.set(authProvider.getHeaderKey(), authProvider.getHeaderValue());
        }
        if (version != null) {
            headerBuilder.set(HEADER_X_OBJECT_VERSION, String.valueOf(version));
        }
        try {
            FileUtils.touch(target);
        }
        catch (IOException e) {
            throw new ClientException(String.format(ERROR_REASON_FILE_CREATION, e.getMessage()), e);
        }
        Request request = new Request.Builder().headers(headerBuilder.build()).url(endpoint).get().build();
        Call call = this.client.newCall(request);
        try (Response response = call.execute();){
            Map<String, List<String>> map;
            block18: {
                BufferedSink sink2 = Okio.buffer(Okio.sink(target));
                try {
                    this.assertSuccessfulResponse(response);
                    sink2.writeAll(response.body().source());
                    sink2.close();
                    map = response.headers().toMultimap();
                    if (sink2 == null) break block18;
                }
                catch (Throwable throwable) {
                    if (sink2 != null) {
                        try {
                            sink2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                sink2.close();
            }
            return map;
        }
        catch (IOException e) {
            throw new ClientException(String.format(ERROR_REASON_IO, e.getMessage()), e);
        }
    }

    public Map<String, List<String>> objectDownload(String accountName, String containerName, YassosAccountAuthProvider authProvider, File target, String objectName) throws ClientException {
        return this.objectDownload(accountName, containerName, authProvider, target, objectName, null);
    }

    public Map<String, List<String>> objectUpload(String accountName, String containerName, YassosAccountAuthProvider authProvider, File source2, String objectName, boolean calculateEtag, String etag, Long deleteAfter, Long deleteAt, Map<String, String> objectMetaData) throws ClientException {
        Assert.hasText(accountName, ASSERT_ACCOUNT_NAME_CANNOT_BE_BLANK);
        Assert.hasText(containerName, ASSERT_CONTAINER_NAME_CANNOT_BE_BLANK);
        Assert.notNull(authProvider, ASSERT_AUTH_PROVIDER_CANNOT_BE_NULL);
        Assert.notNull(source2, ASSERT_SOURCE_CANNOT_BE_NULL);
        Assert.hasText(objectName, ASSERT_OBJECT_NAME_CANNOT_BE_BLANK);
        MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart(FORM_FILE_KEY, source2.getName(), RequestBody.create(MEDIA_TYPE_OCTET_STREAM, source2)).build();
        String endpoint = String.format("%s/%s/%s/%s/%s", this.url, API_VERSION_PREFIX, accountName, containerName, objectName);
        Headers.Builder headerBuilder = new Headers.Builder();
        if (!authProvider.skipHeader()) {
            headerBuilder.set(authProvider.getHeaderKey(), authProvider.getHeaderValue());
        }
        if (objectMetaData != null) {
            for (Map.Entry<String, String> entry : objectMetaData.entrySet()) {
                String k = entry.getKey();
                Assert.hasText(k, ASSERT_METADATA_KEY_CANNOT_BE_BLANK);
                Assert.state(this.isValidHeaderKey(k), ASSERT_METADATA_KEY_ALPHA_NUMERIC);
                String v = entry.getValue();
                Assert.hasText(k, ASSERT_METADATA_VALUE_CANNOT_BE_BLANK);
                headerBuilder.set(String.format("%s%s", HEADER_X_OBJECT_META_PREFIX, k), v);
            }
        }
        if (calculateEtag) {
            try {
                etag = ChecksumUtil.getSha256Hex(source2);
            }
            catch (ChecksumException e) {
                throw new ClientException(String.format(ERROR_REASON_ETAG_CALCULATION, e.getMessage()), e);
            }
        }
        if (StringUtils.isNotBlank(etag)) {
            headerBuilder.set(HEADER_ETAG, etag);
        }
        if (deleteAt != null) {
            headerBuilder.set(HEADER_X_OBJECT_DELETE_AT, String.valueOf(deleteAt));
        }
        if (deleteAfter != null) {
            headerBuilder.set(HEADER_X_OBJECT_DELETE_AFTER, String.valueOf(deleteAfter));
        }
        Request request = new Request.Builder().headers(headerBuilder.build()).url(endpoint).put(requestBody).build();
        Call call = this.client.newCall(request);
        Response response = call.execute();
        try {
            this.assertSuccessfulResponse(response);
            Map<String, List<String>> map = response.headers().toMultimap();
            if (response != null) {
                response.close();
            }
            return map;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ClientException(String.format(ERROR_REASON_IO, e.getMessage()), e);
            }
        }
    }

    public AccountResponse interactiveAuth(YassosInteractiveAuthProvider authProvider) throws ClientException {
        Assert.notNull(authProvider, ASSERT_AUTH_PROVIDER_CANNOT_BE_NULL);
        String endpoint = String.format("%s/%s/auth", this.url, API_VERSION_PREFIX);
        Request.Builder requestBuilder = new Request.Builder().url(endpoint).get();
        if (!authProvider.skipHeader()) {
            requestBuilder.addHeader(authProvider.getHeaderKey(), authProvider.getHeaderValue());
        }
        Request request = requestBuilder.build();
        Call call = this.client.newCall(request);
        Response response = call.execute();
        try {
            this.assertSuccessfulResponse(response);
            AccountResponse accountResponse = this.objectMapper.readValue(response.body().string(), AccountResponse.class);
            if (response != null) {
                response.close();
            }
            return accountResponse;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ClientException(String.format(ERROR_REASON_IO, e.getMessage()), e);
            }
        }
    }

    public Map<String, List<String>> objectMetaDataRetrieval(String accountName, String containerName, YassosAccountAuthProvider authProvider, String objectName) throws ClientException {
        return this.objectMetaDataRetrieval(accountName, containerName, authProvider, objectName, null);
    }

    public Map<String, List<String>> objectMetaDataRetrieval(String accountName, String containerName, YassosAccountAuthProvider authProvider, String objectName, Integer version) throws ClientException {
        Assert.hasText(accountName, ASSERT_ACCOUNT_NAME_CANNOT_BE_BLANK);
        Assert.hasText(containerName, ASSERT_CONTAINER_NAME_CANNOT_BE_BLANK);
        Assert.notNull(authProvider, ASSERT_AUTH_PROVIDER_CANNOT_BE_NULL);
        Assert.hasText(objectName, ASSERT_OBJECT_NAME_CANNOT_BE_BLANK);
        String endpoint = String.format("%s/%s/%s/%s/%s", this.url, API_VERSION_PREFIX, accountName, containerName, objectName);
        Headers.Builder headerBuilder = new Headers.Builder();
        if (!authProvider.skipHeader()) {
            headerBuilder.set(authProvider.getHeaderKey(), authProvider.getHeaderValue());
        }
        if (version != null) {
            headerBuilder.set(HEADER_X_OBJECT_VERSION, String.valueOf(version));
        }
        Request request = new Request.Builder().headers(headerBuilder.build()).url(endpoint).head().build();
        Call call = this.client.newCall(request);
        Response response = call.execute();
        try {
            this.assertSuccessfulResponse(response);
            Map<String, List<String>> map = response.headers().toMultimap();
            if (response != null) {
                response.close();
            }
            return map;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ClientException(String.format(ERROR_REASON_IO, e.getMessage()), e);
            }
        }
    }

    public void objectDeletion(String accountName, String containerName, YassosAccountAuthProvider authProvider, String objectName) throws ClientException {
        this.objectDeletion(accountName, containerName, authProvider, objectName, null);
    }

    public void objectDeletion(String accountName, String containerName, YassosAccountAuthProvider authProvider, String objectName, Integer version) throws ClientException {
        Assert.hasText(accountName, ASSERT_ACCOUNT_NAME_CANNOT_BE_BLANK);
        Assert.hasText(containerName, ASSERT_CONTAINER_NAME_CANNOT_BE_BLANK);
        Assert.notNull(authProvider, ASSERT_AUTH_PROVIDER_CANNOT_BE_NULL);
        Assert.hasText(objectName, ASSERT_OBJECT_NAME_CANNOT_BE_BLANK);
        String endpoint = String.format("%s/%s/%s/%s/%s", this.url, API_VERSION_PREFIX, accountName, containerName, objectName);
        Headers.Builder headerBuilder = new Headers.Builder();
        if (!authProvider.skipHeader()) {
            headerBuilder.set(authProvider.getHeaderKey(), authProvider.getHeaderValue());
        }
        if (version != null) {
            headerBuilder.set(HEADER_X_OBJECT_VERSION, String.valueOf(version));
        }
        Request request = new Request.Builder().headers(headerBuilder.build()).url(endpoint).delete().build();
        Call call = this.client.newCall(request);
        try (Response response = call.execute();){
            this.assertSuccessfulResponse(response);
        }
        catch (IOException e) {
            throw new ClientException(String.format(ERROR_REASON_IO, e.getMessage()), e);
        }
    }

    public AccountResponse accountCreation(String accountName, YassosAdminAuthProvider authProvider) throws ClientException {
        Request.Builder requestBuilder;
        Assert.hasText(accountName, ASSERT_ACCOUNT_NAME_CANNOT_BE_BLANK);
        Assert.notNull(authProvider, ASSERT_AUTH_PROVIDER_CANNOT_BE_NULL);
        String endpoint = String.format("%s/%s", this.url, API_VERSION_PREFIX);
        try {
            String json = this.objectMapper.writeValueAsString(new CreateAccountRequest(accountName));
            RequestBody body = RequestBody.create(json, MEDIA_TYPE_JSON);
            requestBuilder = new Request.Builder().url(endpoint).put(body).addHeader(HEADER_CONTENT_TYPE, HEADER_CONTENT_TYPE_APPLICATION_JSON_VALUE);
            if (!authProvider.skipHeader()) {
                requestBuilder.addHeader(authProvider.getHeaderKey(), authProvider.getHeaderValue());
            }
        }
        catch (IOException e) {
            throw new ClientException(String.format(ERROR_REASON_IO, e.getMessage()), e);
        }
        Request request = requestBuilder.build();
        Call call = this.client.newCall(request);
        Response response = call.execute();
        try {
            this.assertSuccessfulResponse(response);
            AccountResponse accountResponse = this.objectMapper.readValue(response.body().string(), AccountResponse.class);
            if (response != null) {
                response.close();
            }
            return accountResponse;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ClientException(String.format(ERROR_REASON_IO, e.getMessage()), e);
            }
        }
    }

    public AccountsResponse accountList(YassosAdminAuthProvider authProvider) throws ClientException {
        Assert.notNull(authProvider, ASSERT_AUTH_PROVIDER_CANNOT_BE_NULL);
        String endpoint = String.format("%s/%s", this.url, API_VERSION_PREFIX);
        Request.Builder requestBuilder = new Request.Builder().url(endpoint).get();
        if (!authProvider.skipHeader()) {
            requestBuilder.addHeader(authProvider.getHeaderKey(), authProvider.getHeaderValue());
        }
        Request request = requestBuilder.build();
        Call call = this.client.newCall(request);
        Response response = call.execute();
        try {
            this.assertSuccessfulResponse(response);
            AccountsResponse accountsResponse = this.objectMapper.readValue(response.body().string(), AccountsResponse.class);
            if (response != null) {
                response.close();
            }
            return accountsResponse;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ClientException(String.format(ERROR_REASON_IO, e.getMessage()), e);
            }
        }
    }

    public void accountDeletion(String accountName, YassosAdminAuthProvider authProvider) throws ClientException {
        Assert.hasText(accountName, ASSERT_ACCOUNT_NAME_CANNOT_BE_BLANK);
        Assert.notNull(authProvider, ASSERT_AUTH_PROVIDER_CANNOT_BE_NULL);
        String endpoint = String.format("%s/%s/%s", this.url, API_VERSION_PREFIX, accountName);
        Headers.Builder headerBuilder = new Headers.Builder();
        if (!authProvider.skipHeader()) {
            headerBuilder.set(authProvider.getHeaderKey(), authProvider.getHeaderValue());
        }
        Request request = new Request.Builder().headers(headerBuilder.build()).url(endpoint).delete().build();
        Call call = this.client.newCall(request);
        try (Response response = call.execute();){
            this.assertSuccessfulResponse(response);
        }
        catch (IOException e) {
            throw new ClientException(String.format(ERROR_REASON_IO, e.getMessage()), e);
        }
    }

    public ContainerResponse containerCreation(String accountName, String containerName, YassosAccountAuthProvider authProvider) throws ClientException {
        return this.containerCreation(accountName, containerName, false, authProvider);
    }

    public ContainerResponse containerCreation(String accountName, String containerName, boolean versioning, YassosAccountAuthProvider authProvider) throws ClientException {
        Request.Builder requestBuilder;
        Assert.hasText(accountName, ASSERT_ACCOUNT_NAME_CANNOT_BE_BLANK);
        Assert.hasText(containerName, ASSERT_CONTAINER_NAME_CANNOT_BE_BLANK);
        Assert.notNull(authProvider, ASSERT_AUTH_PROVIDER_CANNOT_BE_NULL);
        String endpoint = String.format("%s/%s/%s", this.url, API_VERSION_PREFIX, accountName);
        try {
            String json = this.objectMapper.writeValueAsString(new CreateContainerRequest(containerName, versioning));
            RequestBody body = RequestBody.create(json, MEDIA_TYPE_JSON);
            requestBuilder = new Request.Builder().url(endpoint).put(body).addHeader(HEADER_CONTENT_TYPE, HEADER_CONTENT_TYPE_APPLICATION_JSON_VALUE);
            if (!authProvider.skipHeader()) {
                requestBuilder.addHeader(authProvider.getHeaderKey(), authProvider.getHeaderValue());
            }
        }
        catch (IOException e) {
            throw new ClientException(String.format(ERROR_REASON_IO, e.getMessage()), e);
        }
        Request request = requestBuilder.build();
        Call call = this.client.newCall(request);
        Response response = call.execute();
        try {
            this.assertSuccessfulResponse(response);
            ContainerResponse containerResponse = this.objectMapper.readValue(response.body().string(), ContainerResponse.class);
            if (response != null) {
                response.close();
            }
            return containerResponse;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ClientException(String.format(ERROR_REASON_IO, e.getMessage()), e);
            }
        }
    }

    public void containerDeletion(String accountName, String containerName, YassosAccountAuthProvider authProvider) throws ClientException {
        Assert.hasText(accountName, ASSERT_ACCOUNT_NAME_CANNOT_BE_BLANK);
        Assert.hasText(containerName, ASSERT_CONTAINER_NAME_CANNOT_BE_BLANK);
        Assert.notNull(authProvider, ASSERT_AUTH_PROVIDER_CANNOT_BE_NULL);
        String endpoint = String.format("%s/%s/%s/%s", this.url, API_VERSION_PREFIX, accountName, containerName);
        Headers.Builder headerBuilder = new Headers.Builder();
        if (!authProvider.skipHeader()) {
            headerBuilder.set(authProvider.getHeaderKey(), authProvider.getHeaderValue());
        }
        Request request = new Request.Builder().headers(headerBuilder.build()).url(endpoint).delete().build();
        Call call = this.client.newCall(request);
        try (Response response = call.execute();){
            this.assertSuccessfulResponse(response);
        }
        catch (IOException e) {
            throw new ClientException(String.format(ERROR_REASON_IO, e.getMessage()), e);
        }
    }

    public ContainersResponse containerList(String accountName, YassosAccountAuthProvider authProvider) throws ClientException {
        Assert.hasText(accountName, ASSERT_ACCOUNT_NAME_CANNOT_BE_BLANK);
        Assert.notNull(authProvider, ASSERT_AUTH_PROVIDER_CANNOT_BE_NULL);
        String endpoint = String.format("%s/%s/%s", this.url, API_VERSION_PREFIX, accountName);
        Request.Builder requestBuilder = new Request.Builder().url(endpoint).get();
        if (!authProvider.skipHeader()) {
            requestBuilder.addHeader(authProvider.getHeaderKey(), authProvider.getHeaderValue());
        }
        Request request = requestBuilder.build();
        Call call = this.client.newCall(request);
        Response response = call.execute();
        try {
            this.assertSuccessfulResponse(response);
            ContainersResponse containersResponse = this.objectMapper.readValue(response.body().string(), ContainersResponse.class);
            if (response != null) {
                response.close();
            }
            return containersResponse;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ClientException(String.format(ERROR_REASON_IO, e.getMessage()), e);
            }
        }
    }

    public ContainerPermissionsResponse containerPermissions(String accountName, String containerName, YassosAccountAuthProvider authProvider) throws ClientException {
        Assert.hasText(accountName, ASSERT_ACCOUNT_NAME_CANNOT_BE_BLANK);
        Assert.hasText(containerName, ASSERT_CONTAINER_NAME_CANNOT_BE_BLANK);
        Assert.notNull(authProvider, ASSERT_AUTH_PROVIDER_CANNOT_BE_NULL);
        String endpoint = String.format("%s/%s/%s/%s/%s", this.url, API_VERSION_PREFIX, API_CONTAINER_PERMISSIONS_PATH, accountName, containerName);
        Request.Builder requestBuilder = new Request.Builder().url(endpoint).get();
        if (!authProvider.skipHeader()) {
            requestBuilder.addHeader(authProvider.getHeaderKey(), authProvider.getHeaderValue());
        }
        Request request = requestBuilder.build();
        Call call = this.client.newCall(request);
        Response response = call.execute();
        try {
            this.assertSuccessfulResponse(response);
            ContainerPermissionsResponse containerPermissionsResponse = this.objectMapper.readValue(response.body().string(), ContainerPermissionsResponse.class);
            if (response != null) {
                response.close();
            }
            return containerPermissionsResponse;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ClientException(String.format(ERROR_REASON_IO, e.getMessage()), e);
            }
        }
    }

    public ContainerPermissionResponse containerPermissionCreation(String accountName, String containerName, ContainerPermissionPrivilege privilege, String label, Long expiration, YassosAccountAuthProvider authProvider) throws ClientException {
        Request.Builder requestBuilder;
        Assert.hasText(accountName, ASSERT_ACCOUNT_NAME_CANNOT_BE_BLANK);
        Assert.hasText(containerName, ASSERT_CONTAINER_NAME_CANNOT_BE_BLANK);
        Assert.notNull((Object)privilege, ASSERT_PRIVILEGE_CANNOT_BE_NULL);
        Assert.notNull(authProvider, ASSERT_AUTH_PROVIDER_CANNOT_BE_NULL);
        String endpoint = String.format("%s/%s/%s/%s/%s", this.url, API_VERSION_PREFIX, API_CONTAINER_PERMISSIONS_PATH, accountName, containerName);
        try {
            String json = this.objectMapper.writeValueAsString(new CreateContainerPermissionRequest(privilege, label, expiration));
            RequestBody body = RequestBody.create(json, MEDIA_TYPE_JSON);
            requestBuilder = new Request.Builder().url(endpoint).post(body).addHeader(HEADER_CONTENT_TYPE, HEADER_CONTENT_TYPE_APPLICATION_JSON_VALUE);
            if (!authProvider.skipHeader()) {
                requestBuilder.addHeader(authProvider.getHeaderKey(), authProvider.getHeaderValue());
            }
        }
        catch (IOException e) {
            throw new ClientException(String.format(ERROR_REASON_IO, e.getMessage()), e);
        }
        Request request = requestBuilder.build();
        Call call = this.client.newCall(request);
        Response response = call.execute();
        try {
            this.assertSuccessfulResponse(response);
            ContainerPermissionResponse containerPermissionResponse = this.objectMapper.readValue(response.body().string(), ContainerPermissionResponse.class);
            if (response != null) {
                response.close();
            }
            return containerPermissionResponse;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ClientException(String.format(ERROR_REASON_IO, e.getMessage()), e);
            }
        }
    }

    public ContainerPermissionResponse containerPermissionUpdate(String accountName, String containerName, UUID permissionId, ContainerPermissionPrivilege privilege, YassosAccountAuthProvider authProvider) throws ClientException {
        Request.Builder requestBuilder;
        Assert.hasText(accountName, ASSERT_ACCOUNT_NAME_CANNOT_BE_BLANK);
        Assert.hasText(containerName, ASSERT_CONTAINER_NAME_CANNOT_BE_BLANK);
        Assert.notNull(permissionId, ASSERT_PERMISSION_ID_CANNOT_BE_NULL);
        Assert.notNull((Object)privilege, ASSERT_PRIVILEGE_CANNOT_BE_NULL);
        Assert.notNull(authProvider, ASSERT_AUTH_PROVIDER_CANNOT_BE_NULL);
        String endpoint = String.format("%s/%s/%s/%s/%s/%s", this.url, API_VERSION_PREFIX, API_CONTAINER_PERMISSIONS_PATH, permissionId, accountName, containerName);
        try {
            String json = this.objectMapper.writeValueAsString(new UpdateContainerPermissionRequest(privilege));
            RequestBody body = RequestBody.create(json, MEDIA_TYPE_JSON);
            requestBuilder = new Request.Builder().url(endpoint).put(body).addHeader(HEADER_CONTENT_TYPE, HEADER_CONTENT_TYPE_APPLICATION_JSON_VALUE);
            if (!authProvider.skipHeader()) {
                requestBuilder.addHeader(authProvider.getHeaderKey(), authProvider.getHeaderValue());
            }
        }
        catch (IOException e) {
            throw new ClientException(String.format(ERROR_REASON_IO, e.getMessage()), e);
        }
        Request request = requestBuilder.build();
        Call call = this.client.newCall(request);
        Response response = call.execute();
        try {
            this.assertSuccessfulResponse(response);
            ContainerPermissionResponse containerPermissionResponse = this.objectMapper.readValue(response.body().string(), ContainerPermissionResponse.class);
            if (response != null) {
                response.close();
            }
            return containerPermissionResponse;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ClientException(String.format(ERROR_REASON_IO, e.getMessage()), e);
            }
        }
    }

    public void containerPermissionDeletion(String accountName, String containerName, UUID permissionId, YassosAccountAuthProvider authProvider) throws ClientException {
        Assert.hasText(accountName, ASSERT_ACCOUNT_NAME_CANNOT_BE_BLANK);
        Assert.hasText(containerName, ASSERT_CONTAINER_NAME_CANNOT_BE_BLANK);
        Assert.notNull(permissionId, ASSERT_PERMISSION_ID_CANNOT_BE_NULL);
        Assert.notNull(authProvider, ASSERT_AUTH_PROVIDER_CANNOT_BE_NULL);
        String endpoint = String.format("%s/%s/%s/%s/%s/%s", this.url, API_VERSION_PREFIX, API_CONTAINER_PERMISSIONS_PATH, permissionId, accountName, containerName);
        Headers.Builder headerBuilder = new Headers.Builder();
        if (!authProvider.skipHeader()) {
            headerBuilder.set(authProvider.getHeaderKey(), authProvider.getHeaderValue());
        }
        Request request = new Request.Builder().headers(headerBuilder.build()).url(endpoint).delete().build();
        Call call = this.client.newCall(request);
        try (Response response = call.execute();){
            this.assertSuccessfulResponse(response);
        }
        catch (IOException e) {
            throw new ClientException(String.format(ERROR_REASON_IO, e.getMessage()), e);
        }
    }

    public ContainerContentsResponse containerContents(String accountName, String containerName, YassosAccountAuthProvider authProvider) throws ClientException {
        return this.containerContents(accountName, containerName, null, true, null, null, authProvider);
    }

    public ContainerContentsResponse containerContents(String accountName, String containerName, String prefix, YassosAccountAuthProvider authProvider) throws ClientException {
        return this.containerContents(accountName, containerName, prefix, true, null, null, authProvider);
    }

    public ContainerContentsResponse containerContents(String accountName, String containerName, String prefix, boolean latest, YassosAccountAuthProvider authProvider) throws ClientException {
        return this.containerContents(accountName, containerName, prefix, latest, null, null, authProvider);
    }

    public ContainerContentsResponse containerContents(String accountName, String containerName, String prefix, boolean latest, ContainerContentsOrderBy orderBy, ContainerContentsOrderDirection orderDirection, YassosAccountAuthProvider authProvider) throws ClientException {
        Assert.hasText(accountName, ASSERT_ACCOUNT_NAME_CANNOT_BE_BLANK);
        Assert.hasText(containerName, ASSERT_CONTAINER_NAME_CANNOT_BE_BLANK);
        Assert.notNull(authProvider, ASSERT_AUTH_PROVIDER_CANNOT_BE_NULL);
        String endpoint = String.format("%s/%s/%s/%s", this.url, API_VERSION_PREFIX, accountName, containerName);
        HttpUrl.Builder httpUrlBuilder = HttpUrl.parse(endpoint).newBuilder();
        if (StringUtils.isNotBlank(prefix)) {
            httpUrlBuilder.addQueryParameter(QUERY_PARAM_PREFIX, prefix);
        }
        if (orderBy != null) {
            httpUrlBuilder.addQueryParameter(QUERY_PARAM_ORDER_BY, orderBy.getValue());
        }
        if (orderDirection != null) {
            httpUrlBuilder.addQueryParameter(QUERY_PARAM_ORDER_DIRECTION, orderDirection.getValue());
        }
        httpUrlBuilder.addQueryParameter(QUERY_PARAM_LATEST, String.valueOf(latest));
        HttpUrl httpUrl = httpUrlBuilder.build();
        Request.Builder requestBuilder = new Request.Builder().url(httpUrl).get();
        if (!authProvider.skipHeader()) {
            requestBuilder.addHeader(authProvider.getHeaderKey(), authProvider.getHeaderValue());
        }
        Request request = requestBuilder.build();
        Call call = this.client.newCall(request);
        Response response = call.execute();
        try {
            this.assertSuccessfulResponse(response);
            ContainerContentsResponse containerContentsResponse = this.objectMapper.readValue(response.body().string(), ContainerContentsResponse.class);
            if (response != null) {
                response.close();
            }
            return containerContentsResponse;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ClientException(String.format(ERROR_REASON_IO, e.getMessage()), e);
            }
        }
    }

    public InfoResponse getInfo() throws ClientException {
        String endpoint = String.format("%s/%s/info", this.url, API_VERSION_PREFIX);
        HttpUrl.Builder httpUrlBuilder = HttpUrl.parse(endpoint).newBuilder();
        HttpUrl httpUrl = httpUrlBuilder.build();
        Request.Builder requestBuilder = new Request.Builder().url(httpUrl).get();
        Request request = requestBuilder.build();
        Call call = this.client.newCall(request);
        Response response = call.execute();
        try {
            this.assertSuccessfulResponse(response);
            InfoResponse infoResponse = this.objectMapper.readValue(response.body().string(), InfoResponse.class);
            if (response != null) {
                response.close();
            }
            return infoResponse;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ClientException(String.format(ERROR_REASON_IO, e.getMessage()), e);
            }
        }
    }

    public HealthResponse getHealth() throws ClientException {
        String endpoint = String.format("%s/%s/health", this.url, API_VERSION_PREFIX);
        HttpUrl.Builder httpUrlBuilder = HttpUrl.parse(endpoint).newBuilder();
        HttpUrl httpUrl = httpUrlBuilder.build();
        Request.Builder requestBuilder = new Request.Builder().url(httpUrl).get();
        Request request = requestBuilder.build();
        Call call = this.client.newCall(request);
        Response response = call.execute();
        try {
            this.assertSuccessfulResponse(response);
            HealthResponse healthResponse = this.objectMapper.readValue(response.body().string(), HealthResponse.class);
            if (response != null) {
                response.close();
            }
            return healthResponse;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ClientException(String.format(ERROR_REASON_IO, e.getMessage()), e);
            }
        }
    }

    @Override
    public void close() throws Exception {
        for (Call call : this.client.dispatcher().queuedCalls()) {
            call.cancel();
        }
        for (Call call : this.client.dispatcher().runningCalls()) {
            call.cancel();
        }
    }

    public boolean isValidHeaderKey(String key) {
        Matcher matcher = ALLOWED_HEADER_KEY_PATTERN.matcher(key);
        return matcher.find();
    }

    private ErrorCode mapHttpErrorStatusToErrorCode(int errorCode) throws ClientException {
        Assert.state(errorCode >= 300, ASSERT_ERROR_CODE_CANNOT_BE_GREATER_THAN_299);
        switch (errorCode) {
            case 400: {
                return ErrorCode.ILLEGAL_ARGUMENT;
            }
            case 401: {
                return ErrorCode.UNAUTHORIZED;
            }
            case 403: {
                return ErrorCode.FORBIDDEN;
            }
            case 404: {
                return ErrorCode.NOT_FOUND;
            }
            case 409: {
                return ErrorCode.CONFLICT;
            }
            case 422: {
                return ErrorCode.UNPROCESSABLE;
            }
        }
        return ErrorCode.GENERAL;
    }

    private void assertSuccessfulResponse(Response response) throws ClientException {
        Assert.notNull(response, "'response' cannot be null");
        if (!response.isSuccessful()) {
            ErrorCode errorCode = this.mapHttpErrorStatusToErrorCode(response.code());
            throw new ClientException(errorCode, errorCode.getCode());
        }
    }
}

