/*
 * Decompiled with CFR 0.152.
 */
package com.altair.yassos.client.util;

import com.altair.relocation.yassos.org.apache.commons.lang3.StringUtils;
import com.altair.yassos.client.error.IllegalArgumentClientException;
import java.util.List;
import java.util.Set;

public final class Assert {
    private Assert() {
        throw new IllegalStateException("Utility class");
    }

    public static void hasText(String value, String message) throws IllegalArgumentClientException {
        if (StringUtils.isBlank(value)) {
            throw new IllegalArgumentClientException(message);
        }
    }

    public static void notNull(Object value, String message) throws IllegalArgumentClientException {
        if (value == null) {
            throw new IllegalArgumentClientException(message);
        }
    }

    public static void isNull(Object value, String message) throws IllegalArgumentClientException {
        if (value != null) {
            throw new IllegalArgumentClientException(message);
        }
    }

    public static void state(boolean value, String message) throws IllegalArgumentClientException {
        if (!value) {
            throw new IllegalArgumentClientException(message);
        }
    }

    public static void atLeastOneNotNull(List<Object> values2, String message) throws IllegalArgumentClientException {
        for (Object value : values2) {
            if (value == null) continue;
            return;
        }
        throw new IllegalArgumentClientException(message);
    }

    public static void allHaveText(Set<String> values2, String message) throws IllegalArgumentClientException {
        if (values2 != null) {
            for (String group : values2) {
                Assert.hasText(group, message);
            }
        }
    }
}

