/*
 * Decompiled with CFR 0.152.
 */
package com.altair.yassos.client.util;

import com.altair.relocation.yassos.org.apache.commons.codec.digest.DigestUtils;
import com.altair.yassos.client.error.ChecksumException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;

public final class ChecksumUtil {
    public static String getSha256Hex(File file) throws ChecksumException {
        if (file == null || !file.exists()) {
            throw new ChecksumException("'file' cannot be null");
        }
        MessageDigest md = DigestUtils.getSha256Digest();
        try (FileInputStream fis = new FileInputStream(file);){
            int nread;
            byte[] buffer = new byte[0xA00000];
            while ((nread = ((InputStream)fis).read(buffer)) != -1) {
                md.update(buffer, 0, nread);
            }
        }
        catch (IOException e) {
            throw new ChecksumException("Could not ", e);
        }
        return ChecksumUtil.convertToHex(md.digest());
    }

    public static String convertToHex(byte[] messageDigest) throws ChecksumException {
        if (messageDigest == null) {
            throw new ChecksumException("'messageDigest' cannot be null");
        }
        StringBuilder builder = new StringBuilder();
        for (byte b : messageDigest) {
            builder.append(String.format("%02X", b));
        }
        return builder.toString().toLowerCase();
    }

    private ChecksumUtil() {
        throw new IllegalStateException("Utility class");
    }
}

